//`include "Types.sv"

module BramMerge4(
  input logic clk,
  input Cmd_t cmd0_d,
  output logic cmd0_r,
  input Cmd_t cmd1_d,
  output logic cmd1_r,
  input Cmd_t cmd2_d,
  output logic cmd2_r,
  input Cmd_t cmd3_d,
  output logic cmd3_r,
  input Res_t res_in_d,
  output logic res_in_r,
  output Res_t res0_dout,
  input logic res0_rout,
  output Res_t res1_dout,
  input logic res1_rout,
  output Res_t res2_dout,
  input logic res2_rout,
  output Res_t res3_dout,
  input logic res3_rout,
  output Cmd_t cmd_out_dout,
  input logic cmd_out_rout
  );
  /* --define=INPUTS=((cmd0, 50, 1125899906842624, Cmd), (cmd1, 50, 1125899906842624, Cmd), (cmd2, 50, 1125899906842624, Cmd), (cmd3, 50, 1125899906842624, Cmd), (res_in, 34, 17179869184, Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((res0, 34, 17179869184, Res), (res1, 34, 17179869184, Res), (res2, 34, 17179869184, Res), (res3, 34, 17179869184, Res), (cmd_out, 50, 1125899906842624, Cmd)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter RES_MSB = NODE_BITS; //34;
   parameter CMD_MSB = NODE_BITS+POINTER_BITS-1; //50;

  Cmd_t i0_d;
  logic i0_r;
  Cmd_t i1_d;
  logic i1_r;
  Cmd_t i2_d;
  logic i2_r;
  Cmd_t i3_d;
  logic i3_r;
  Cmd_t ii0_d;
  logic ii0_r;
  Cmd_t ii1_d;
  logic ii1_r;
  Cmd_t ii2_d;
  logic ii2_r;
  Cmd_t ii3_d;
  logic ii3_r;
  Res_t i4_d;
  logic i4_r;
  Res_t ii4_d;
  logic ii4_r;
  Sel4_t s_d;
  logic s_r;
  Cmd_t ccmd_out_d;
  logic ccmd_out_r;
  Cmd_t cmd_out_d;
  logic cmd_out_r;
  Sel4_t ss_d;
  logic ss_r;
  Sel4_t sss_d;
  logic sss_r;
  Sel4_t ssss_d;
  logic ssss_r;
  Sel4_t sssss_d;
  logic sssss_r;
  Res_t rres0_d;
  logic rres0_r;
  Res_t rres1_d;
  logic rres1_r;
  Res_t rres2_d;
  logic rres2_r;
  Res_t rres3_d;
  logic rres3_r;
  Res_t res0_d;
  logic res0_r;
  Res_t res1_d;
  logic res1_r;
  Res_t res2_d;
  logic res2_r;
  Res_t res3_d;
  logic res3_r;
  
  /* source (Ty Cmd) : > (cmd0,Cmd) */
  
  /* source (Ty Cmd) : > (cmd1,Cmd) */
  
  /* source (Ty Cmd) : > (cmd2,Cmd) */
  
  /* source (Ty Cmd) : > (cmd3,Cmd) */
  
  /* source (Ty Res) : > (res_in,Res) */
  
  /* buf (Ty Cmd) : (cmd0,Cmd) > (i0,Cmd) */
  Cmd_t cmd0_bufchan_d;
  logic cmd0_bufchan_r;
  Cmd_t cmd0_buf;
  initial cmd0_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd0_r = (! cmd0_buf[0]);
  assign cmd0_bufchan_d = (cmd0_buf[0] ? cmd0_buf :
                           cmd0_d);
  always_ff @(posedge clk)
    if ((cmd0_bufchan_r && cmd0_buf[0])) cmd0_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd0_bufchan_r) && (! cmd0_buf[0])))
      cmd0_buf <= cmd0_d;
  initial i0_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd0_bufchan_r = ((! i0_d[0]) || i0_r);
  always_ff @(posedge clk)
    if (cmd0_bufchan_r) i0_d <= cmd0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i0_d[0] && (! i0_r))) $display("%5t blocked: i0", $time);
  `endif
  
  /* buf (Ty Cmd) : (cmd1,Cmd) > (i1,Cmd) */
  Cmd_t cmd1_bufchan_d;
  logic cmd1_bufchan_r;
  Cmd_t cmd1_buf;
  initial cmd1_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd1_r = (! cmd1_buf[0]);
  assign cmd1_bufchan_d = (cmd1_buf[0] ? cmd1_buf :
                           cmd1_d);
  always_ff @(posedge clk)
    if ((cmd1_bufchan_r && cmd1_buf[0])) cmd1_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd1_bufchan_r) && (! cmd1_buf[0])))
      cmd1_buf <= cmd1_d;
  initial i1_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd1_bufchan_r = ((! i1_d[0]) || i1_r);
  always_ff @(posedge clk)
    if (cmd1_bufchan_r) i1_d <= cmd1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i1_d[0] && (! i1_r))) $display("%5t blocked: i1", $time);
  `endif
  
  /* buf (Ty Cmd) : (cmd2,Cmd) > (i2,Cmd) */
  Cmd_t cmd2_bufchan_d;
  logic cmd2_bufchan_r;
  Cmd_t cmd2_buf;
  initial cmd2_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd2_r = (! cmd2_buf[0]);
  assign cmd2_bufchan_d = (cmd2_buf[0] ? cmd2_buf :
                           cmd2_d);
  always_ff @(posedge clk)
    if ((cmd2_bufchan_r && cmd2_buf[0])) cmd2_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd2_bufchan_r) && (! cmd2_buf[0])))
      cmd2_buf <= cmd2_d;
  initial i2_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd2_bufchan_r = ((! i2_d[0]) || i2_r);
  always_ff @(posedge clk)
    if (cmd2_bufchan_r) i2_d <= cmd2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i2_d[0] && (! i2_r))) $display("%5t blocked: i2", $time);
  `endif
  
  /* buf (Ty Cmd) : (cmd3,Cmd) > (i3,Cmd) */
  Cmd_t cmd3_bufchan_d;
  logic cmd3_bufchan_r;
  Cmd_t cmd3_buf;
  initial cmd3_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd3_r = (! cmd3_buf[0]);
  assign cmd3_bufchan_d = (cmd3_buf[0] ? cmd3_buf :
                           cmd3_d);
  always_ff @(posedge clk)
    if ((cmd3_bufchan_r && cmd3_buf[0])) cmd3_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd3_bufchan_r) && (! cmd3_buf[0])))
      cmd3_buf <= cmd3_d;
  initial i3_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign cmd3_bufchan_r = ((! i3_d[0]) || i3_r);
  always_ff @(posedge clk)
    if (cmd3_bufchan_r) i3_d <= cmd3_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i3_d[0] && (! i3_r))) $display("%5t blocked: i3", $time);
  `endif
  
  /* buf (Ty Cmd) : (i0,Cmd) > (ii0,Cmd) */
  Cmd_t i0_bufchan_d;
  logic i0_bufchan_r;
  Cmd_t i0_buf;
  initial i0_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign i0_r = (! i0_buf[0]);
  assign i0_bufchan_d = (i0_buf[0] ? i0_buf :
                         i0_d);
  always_ff @(posedge clk)
    if ((i0_bufchan_r && i0_buf[0])) i0_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! i0_bufchan_r) && (! i0_buf[0]))) i0_buf <= i0_d;
  initial ii0_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign i0_bufchan_r = ((! ii0_d[0]) || ii0_r);
  always_ff @(posedge clk)
    if (i0_bufchan_r) ii0_d <= i0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii0_d[0] && (! ii0_r))) $display("%5t blocked: ii0", $time);
  `endif
  
  /* buf (Ty Cmd) : (i1,Cmd) > (ii1,Cmd) */
  Cmd_t i1_bufchan_d;
  logic i1_bufchan_r;
  Cmd_t i1_buf;
  initial i1_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign i1_r = (! i1_buf[0]);
  assign i1_bufchan_d = (i1_buf[0] ? i1_buf :
                         i1_d);
  always_ff @(posedge clk)
    if ((i1_bufchan_r && i1_buf[0])) i1_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! i1_bufchan_r) && (! i1_buf[0]))) i1_buf <= i1_d;
  initial ii1_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign i1_bufchan_r = ((! ii1_d[0]) || ii1_r);
  always_ff @(posedge clk)
    if (i1_bufchan_r) ii1_d <= i1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii1_d[0] && (! ii1_r))) $display("%5t blocked: ii1", $time);
  `endif
  
  /* buf (Ty Cmd) : (i2,Cmd) > (ii2,Cmd) */
  Cmd_t i2_bufchan_d;
  logic i2_bufchan_r;
  Cmd_t i2_buf;
  initial i2_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign i2_r = (! i2_buf[0]);
  assign i2_bufchan_d = (i2_buf[0] ? i2_buf :
                         i2_d);
  always_ff @(posedge clk)
    if ((i2_bufchan_r && i2_buf[0])) i2_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! i2_bufchan_r) && (! i2_buf[0]))) i2_buf <= i2_d;
  initial ii2_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign i2_bufchan_r = ((! ii2_d[0]) || ii2_r);
  always_ff @(posedge clk)
    if (i2_bufchan_r) ii2_d <= i2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii2_d[0] && (! ii2_r))) $display("%5t blocked: ii2", $time);
  `endif
  
  /* buf (Ty Cmd) : (i3,Cmd) > (ii3,Cmd) */
  Cmd_t i3_bufchan_d;
  logic i3_bufchan_r;
  Cmd_t i3_buf;
  initial i3_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign i3_r = (! i3_buf[0]);
  assign i3_bufchan_d = (i3_buf[0] ? i3_buf :
                         i3_d);
  always_ff @(posedge clk)
    if ((i3_bufchan_r && i3_buf[0])) i3_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! i3_bufchan_r) && (! i3_buf[0]))) i3_buf <= i3_d;
  initial ii3_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign i3_bufchan_r = ((! ii3_d[0]) || ii3_r);
  always_ff @(posedge clk)
    if (i3_bufchan_r) ii3_d <= i3_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii3_d[0] && (! ii3_r))) $display("%5t blocked: ii3", $time);
  `endif
  
  /* buf (Ty Res) : (res_in,Res) > (i4,Res) */
  Res_t res_in_bufchan_d;
  logic res_in_bufchan_r;
  Res_t res_in_buf;
  initial res_in_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign res_in_r = (! res_in_buf[0]);
  assign res_in_bufchan_d = (res_in_buf[0] ? res_in_buf :
                             res_in_d);
  always_ff @(posedge clk)
    if ((res_in_bufchan_r && res_in_buf[0]))
      res_in_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! res_in_bufchan_r) && (! res_in_buf[0])))
      res_in_buf <= res_in_d;
  initial i4_d = {{RES_MSB{1'bx}}, 1'd0};
  assign res_in_bufchan_r = ((! i4_d[0]) || i4_r);
  always_ff @(posedge clk)
    if (res_in_bufchan_r) i4_d <= res_in_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i4_d[0] && (! i4_r))) $display("%5t blocked: i4", $time);
  `endif
  
  /* buf (Ty Res) : (i4,Res) > (ii4,Res) */
  Res_t i4_bufchan_d;
  logic i4_bufchan_r;
  Res_t i4_buf;
  initial i4_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign i4_r = (! i4_buf[0]);
  assign i4_bufchan_d = (i4_buf[0] ? i4_buf :
                         i4_d);
  always_ff @(posedge clk)
    if ((i4_bufchan_r && i4_buf[0])) i4_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! i4_bufchan_r) && (! i4_buf[0]))) i4_buf <= i4_d;
  initial ii4_d = {{RES_MSB{1'bx}}, 1'd0};
  assign i4_bufchan_r = ((! ii4_d[0]) || ii4_r);
  always_ff @(posedge clk)
    if (i4_bufchan_r) ii4_d <= i4_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii4_d[0] && (! ii4_r))) $display("%5t blocked: ii4", $time);
  `endif
  
  /* mergectrl (Ty Sel4,Ty Cmd) : [(ii0,Cmd),
                              (ii1,Cmd),
                              (ii2,Cmd),
                              (ii3,Cmd)] > (s,Sel4) (ccmd_out,Cmd) */
  logic [3:0] ii0_select_d;
  assign ii0_select_d = ((| ii0_select_q) ? ii0_select_q :
                         (ii0_d[0] ? 4'd1 :
                          (ii1_d[0] ? 4'd2 :
                           (ii2_d[0] ? 4'd4 :
                            (ii3_d[0] ? 4'd8 :
                             4'd0)))));
  logic [3:0] ii0_select_q;
  initial ii0_select_q = 4'd0;
  always_ff @(posedge clk)
    ii0_select_q <= (ii0_done ? 4'd0 :
                     ii0_select_d);
  logic [1:0] ii0_emit_q;
  initial ii0_emit_q = 2'd0;
  always_ff @(posedge clk)
    ii0_emit_q <= (ii0_done ? 2'd0 :
                   ii0_emit_d);
  logic [1:0] ii0_emit_d;
  assign ii0_emit_d = (ii0_emit_q | ({s_d[0], ccmd_out_d[0]} & {s_r,
                                                                ccmd_out_r}));
  logic ii0_done;
  assign ii0_done = (& ii0_emit_d);
  assign {ii3_r, ii2_r, ii1_r, ii0_r} = (ii0_done ? ii0_select_d :
                                         4'd0);
  assign ccmd_out_d = ((ii0_select_d[0] && (! ii0_emit_q[0])) ? ii0_d :
                       ((ii0_select_d[1] && (! ii0_emit_q[0])) ? ii1_d :
                        ((ii0_select_d[2] && (! ii0_emit_q[0])) ? ii2_d :
                         ((ii0_select_d[3] && (! ii0_emit_q[0])) ? ii3_d :
                          {{CMD_MSB{1'bx}}, 1'd0}))));
  assign s_d = ((ii0_select_d[0] && (! ii0_emit_q[1])) ? I40_dc(1'd1) :
                ((ii0_select_d[1] && (! ii0_emit_q[1])) ? I41_dc(1'd1) :
                 ((ii0_select_d[2] && (! ii0_emit_q[1])) ? I42_dc(1'd1) :
                  ((ii0_select_d[3] && (! ii0_emit_q[1])) ? I43_dc(1'd1) :
                   {2'bx, 1'd0}))));
  
  /* buf (Ty Cmd) : (ccmd_out,Cmd) > (cmd_out,Cmd) */
  Cmd_t ccmd_out_bufchan_d;
  logic ccmd_out_bufchan_r;
  Cmd_t ccmd_out_buf;
  initial ccmd_out_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign ccmd_out_r = (! ccmd_out_buf[0]);
  assign ccmd_out_bufchan_d = (ccmd_out_buf[0] ? ccmd_out_buf :
                               ccmd_out_d);
  always_ff @(posedge clk)
    if ((ccmd_out_bufchan_r && ccmd_out_buf[0]))
      ccmd_out_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! ccmd_out_bufchan_r) && (! ccmd_out_buf[0])))
      ccmd_out_buf <= ccmd_out_d;
  initial cmd_out_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign ccmd_out_bufchan_r = ((! cmd_out_d[0]) || cmd_out_r);
  always_ff @(posedge clk)
    if (ccmd_out_bufchan_r) cmd_out_d <= ccmd_out_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((cmd_out_d[0] && (! cmd_out_r)))
      $display("%5t blocked: cmd_out", $time);
  `endif
  
  /* buf (Ty Sel4) : (s,Sel4) > (ss,Sel4) */
  Sel4_t s_bufchan_d;
  logic s_bufchan_r;
  Sel4_t s_buf;
  initial s_buf = {2'bx, 1'd0};
  assign s_r = (! s_buf[0]);
  assign s_bufchan_d = (s_buf[0] ? s_buf :
                        s_d);
  always_ff @(posedge clk)
    if ((s_bufchan_r && s_buf[0])) s_buf <= {2'bx, 1'd0};
    else if (((! s_bufchan_r) && (! s_buf[0]))) s_buf <= s_d;
  initial ss_d = {2'bx, 1'd0};
  assign s_bufchan_r = ((! ss_d[0]) || ss_r);
  always_ff @(posedge clk)
    if (s_bufchan_r) ss_d <= s_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ss_d[0] && (! ss_r))) $display("%5t blocked: ss", $time);
  `endif
  
  /* buf (Ty Sel4) : (ss,Sel4) > (sss,Sel4) */
  Sel4_t ss_bufchan_d;
  logic ss_bufchan_r;
  Sel4_t ss_buf;
  initial ss_buf = {2'bx, 1'd0};
  assign ss_r = (! ss_buf[0]);
  assign ss_bufchan_d = (ss_buf[0] ? ss_buf :
                         ss_d);
  always_ff @(posedge clk)
    if ((ss_bufchan_r && ss_buf[0])) ss_buf <= {2'bx, 1'd0};
    else if (((! ss_bufchan_r) && (! ss_buf[0]))) ss_buf <= ss_d;
  initial sss_d = {2'bx, 1'd0};
  assign ss_bufchan_r = ((! sss_d[0]) || sss_r);
  always_ff @(posedge clk)
    if (ss_bufchan_r) sss_d <= ss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sss_d[0] && (! sss_r))) $display("%5t blocked: sss", $time);
  `endif
  
  /* buf (Ty Sel4) : (sss,Sel4) > (ssss,Sel4) */
  Sel4_t sss_bufchan_d;
  logic sss_bufchan_r;
  Sel4_t sss_buf;
  initial sss_buf = {2'bx, 1'd0};
  assign sss_r = (! sss_buf[0]);
  assign sss_bufchan_d = (sss_buf[0] ? sss_buf :
                          sss_d);
  always_ff @(posedge clk)
    if ((sss_bufchan_r && sss_buf[0])) sss_buf <= {2'bx, 1'd0};
    else if (((! sss_bufchan_r) && (! sss_buf[0]))) sss_buf <= sss_d;
  initial ssss_d = {2'bx, 1'd0};
  assign sss_bufchan_r = ((! ssss_d[0]) || ssss_r);
  always_ff @(posedge clk)
    if (sss_bufchan_r) ssss_d <= sss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ssss_d[0] && (! ssss_r)))
      $display("%5t blocked: ssss", $time);
  `endif
  
  /* buf (Ty Sel4) : (ssss,Sel4) > (sssss,Sel4) */
  Sel4_t ssss_bufchan_d;
  logic ssss_bufchan_r;
  Sel4_t ssss_buf;
  initial ssss_buf = {2'bx, 1'd0};
  assign ssss_r = (! ssss_buf[0]);
  assign ssss_bufchan_d = (ssss_buf[0] ? ssss_buf :
                           ssss_d);
  always_ff @(posedge clk)
    if ((ssss_bufchan_r && ssss_buf[0])) ssss_buf <= {2'bx, 1'd0};
    else if (((! ssss_bufchan_r) && (! ssss_buf[0])))
      ssss_buf <= ssss_d;
  initial sssss_d = {2'bx, 1'd0};
  assign ssss_bufchan_r = ((! sssss_d[0]) || sssss_r);
  always_ff @(posedge clk)
    if (ssss_bufchan_r) sssss_d <= ssss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sssss_d[0] && (! sssss_r)))
      $display("%5t blocked: sssss", $time);
  `endif
  
  /* demux (Ty Sel4,Ty Res) : (sssss,Sel4) (ii4,Res) > [(rres0,Res),
                                                   (rres1,Res),
                                                   (rres2,Res),
                                                   (rres3,Res)] */
  logic [3:0] ii4_onehotd;
  always_comb
    if ((sssss_d[0] && ii4_d[0]))
      unique case (sssss_d[2:1])
        2'd0: ii4_onehotd = 4'd1;
        2'd1: ii4_onehotd = 4'd2;
        2'd2: ii4_onehotd = 4'd4;
        2'd3: ii4_onehotd = 4'd8;
        default: ii4_onehotd = 4'bx;
      endcase
    else ii4_onehotd = 4'd0;
  assign rres0_d = {ii4_d[RES_MSB:1], ii4_onehotd[0]};
  assign rres1_d = {ii4_d[RES_MSB:1], ii4_onehotd[1]};
  assign rres2_d = {ii4_d[RES_MSB:1], ii4_onehotd[2]};
  assign rres3_d = {ii4_d[RES_MSB:1], ii4_onehotd[3]};
  assign ii4_r = (| (ii4_onehotd & {rres3_r,
                                    rres2_r,
                                    rres1_r,
                                    rres0_r}));
  assign sssss_r = ii4_r;
  
  /* buf (Ty Res) : (rres0,Res) > (res0,Res) */
  Res_t rres0_bufchan_d;
  logic rres0_bufchan_r;
  Res_t rres0_buf;
  initial rres0_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign rres0_r = (! rres0_buf[0]);
  assign rres0_bufchan_d = (rres0_buf[0] ? rres0_buf :
                            rres0_d);
  always_ff @(posedge clk)
    if ((rres0_bufchan_r && rres0_buf[0])) rres0_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! rres0_bufchan_r) && (! rres0_buf[0])))
      rres0_buf <= rres0_d;
  initial res0_d = {{RES_MSB{1'bx}}, 1'd0};
  assign rres0_bufchan_r = ((! res0_d[0]) || res0_r);
  always_ff @(posedge clk)
    if (rres0_bufchan_r) res0_d <= rres0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res0_d[0] && (! res0_r)))
      $display("%5t blocked: res0", $time);
  `endif
  
  /* buf (Ty Res) : (rres1,Res) > (res1,Res) */
  Res_t rres1_bufchan_d;
  logic rres1_bufchan_r;
  Res_t rres1_buf;
  initial rres1_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign rres1_r = (! rres1_buf[0]);
  assign rres1_bufchan_d = (rres1_buf[0] ? rres1_buf :
                            rres1_d);
  always_ff @(posedge clk)
    if ((rres1_bufchan_r && rres1_buf[0])) rres1_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! rres1_bufchan_r) && (! rres1_buf[0])))
      rres1_buf <= rres1_d;
  initial res1_d = {{RES_MSB{1'bx}}, 1'd0};
  assign rres1_bufchan_r = ((! res1_d[0]) || res1_r);
  always_ff @(posedge clk)
    if (rres1_bufchan_r) res1_d <= rres1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res1_d[0] && (! res1_r)))
      $display("%5t blocked: res1", $time);
  `endif
  
  /* buf (Ty Res) : (rres2,Res) > (res2,Res) */
  Res_t rres2_bufchan_d;
  logic rres2_bufchan_r;
  Res_t rres2_buf;
  initial rres2_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign rres2_r = (! rres2_buf[0]);
  assign rres2_bufchan_d = (rres2_buf[0] ? rres2_buf :
                            rres2_d);
  always_ff @(posedge clk)
    if ((rres2_bufchan_r && rres2_buf[0])) rres2_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! rres2_bufchan_r) && (! rres2_buf[0])))
      rres2_buf <= rres2_d;
  initial res2_d = {{RES_MSB{1'bx}}, 1'd0};
  assign rres2_bufchan_r = ((! res2_d[0]) || res2_r);
  always_ff @(posedge clk)
    if (rres2_bufchan_r) res2_d <= rres2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res2_d[0] && (! res2_r)))
      $display("%5t blocked: res2", $time);
  `endif
  
  /* buf (Ty Res) : (rres3,Res) > (res3,Res) */
  Res_t rres3_bufchan_d;
  logic rres3_bufchan_r;
  Res_t rres3_buf;
  initial rres3_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign rres3_r = (! rres3_buf[0]);
  assign rres3_bufchan_d = (rres3_buf[0] ? rres3_buf :
                            rres3_d);
  always_ff @(posedge clk)
    if ((rres3_bufchan_r && rres3_buf[0])) rres3_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! rres3_bufchan_r) && (! rres3_buf[0])))
      rres3_buf <= rres3_d;
  initial res3_d = {{RES_MSB{1'bx}}, 1'd0};
  assign rres3_bufchan_r = ((! res3_d[0]) || res3_r);
  always_ff @(posedge clk)
    if (rres3_bufchan_r) res3_d <= rres3_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res3_d[0] && (! res3_r)))
      $display("%5t blocked: res3", $time);
  `endif
  
  /* sink (Ty Res) : (res0,Res) > */
  assign {res0_r, res0_dout} = {res0_rout, res0_d};
  
  /* sink (Ty Res) : (res1,Res) > */
  assign {res1_r, res1_dout} = {res1_rout, res1_d};
  
  /* sink (Ty Res) : (res2,Res) > */
  assign {res2_r, res2_dout} = {res2_rout, res2_d};
  
  /* sink (Ty Res) : (res3,Res) > */
  assign {res3_r, res3_dout} = {res3_rout, res3_d};
  
  /* sink (Ty Cmd) : (cmd_out,Cmd) > */
  assign {cmd_out_r, cmd_out_dout} = {cmd_out_rout, cmd_out_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [18:0] bufferedChannelValids;
  logic [18:0] bufferedChannelReadys;
  logic [18:0] last1BufferedChannelValids;
  logic [18:0] last1BufferedChannelReadys;
  logic [18:0] last2BufferedChannelValids;
  logic [18:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 19'd0;
  initial last1BufferedChannelReadys = 19'd0;
  initial last2BufferedChannelValids = 19'd1;
  initial last2BufferedChannelReadys = 19'd1;
  assign bufferedChannelValids = {i0_d[0],
                                  i1_d[0],
                                  i2_d[0],
                                  i3_d[0],
                                  ii0_d[0],
                                  ii1_d[0],
                                  ii2_d[0],
                                  ii3_d[0],
                                  i4_d[0],
                                  ii4_d[0],
                                  cmd_out_d[0],
                                  ss_d[0],
                                  sss_d[0],
                                  ssss_d[0],
                                  sssss_d[0],
                                  res0_d[0],
                                  res1_d[0],
                                  res2_d[0],
                                  res3_d[0]};
  assign bufferedChannelReadys = {i0_r,
                                  i1_r,
                                  i2_r,
                                  i3_r,
                                  ii0_r,
                                  ii1_r,
                                  ii2_r,
                                  ii3_r,
                                  i4_r,
                                  ii4_r,
                                  cmd_out_r,
                                  ss_r,
                                  sss_r,
                                  ssss_r,
                                  sssss_r,
                                  res0_r,
                                  res1_r,
                                  res2_r,
                                  res3_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((i0_d[0] && (! i0_r))) $display(" blocked i0");
          if ((i1_d[0] && (! i1_r))) $display(" blocked i1");
          if ((i2_d[0] && (! i2_r))) $display(" blocked i2");
          if ((i3_d[0] && (! i3_r))) $display(" blocked i3");
          if ((ii0_d[0] && (! ii0_r))) $display(" blocked ii0");
          if ((ii1_d[0] && (! ii1_r))) $display(" blocked ii1");
          if ((ii2_d[0] && (! ii2_r))) $display(" blocked ii2");
          if ((ii3_d[0] && (! ii3_r))) $display(" blocked ii3");
          if ((i4_d[0] && (! i4_r))) $display(" blocked i4");
          if ((ii4_d[0] && (! ii4_r))) $display(" blocked ii4");
          if ((cmd_out_d[0] && (! cmd_out_r))) $display(" blocked cmd_out");
          if ((ss_d[0] && (! ss_r))) $display(" blocked ss");
          if ((sss_d[0] && (! sss_r))) $display(" blocked sss");
          if ((ssss_d[0] && (! ssss_r))) $display(" blocked ssss");
          if ((sssss_d[0] && (! sssss_r))) $display(" blocked sssss");
          if ((res0_d[0] && (! res0_r))) $display(" blocked res0");
          if ((res1_d[0] && (! res1_r))) $display(" blocked res1");
          if ((res2_d[0] && (! res2_r))) $display(" blocked res2");
          if ((res3_d[0] && (! res3_r))) $display(" blocked res3");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake i0:buf */
  /* wake i1:buf */
  /* wake i2:buf */
  /* wake i3:buf */
  /* wake ii0:buf */
  /* wake ii1:buf */
  /* wake ii2:buf */
  /* wake ii3:buf */
  /* wake i4:buf */
  /* wake ii4:buf */
  /* wake cmd_out:buf */
  /* wake ss:buf */
  /* wake sss:buf */
  /* wake ssss:buf */
  /* wake sssss:buf */
  /* wake res0:buf */
  /* wake res1:buf */
  /* wake res2:buf */
  /* wake res3:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(i0_d[0] || (cmd0_d[0] || cmd0_bufchan_d[0])),
                         (i1_d[0] || (cmd1_d[0] || cmd1_bufchan_d[0])),
                         (i2_d[0] || (cmd2_d[0] || cmd2_bufchan_d[0])),
                         (i3_d[0] || (cmd3_d[0] || cmd3_bufchan_d[0])),
                         (ii0_d[0] || (i0_d[0] || i0_bufchan_d[0])),
                         (ii1_d[0] || (i1_d[0] || i1_bufchan_d[0])),
                         (ii2_d[0] || (i2_d[0] || i2_bufchan_d[0])),
                         (ii3_d[0] || (i3_d[0] || i3_bufchan_d[0])),
                         (i4_d[0] || (res_in_d[0] || res_in_bufchan_d[0])),
                         (ii4_d[0] || (i4_d[0] || i4_bufchan_d[0])),
                         (cmd_out_d[0] || (ccmd_out_d[0] || ccmd_out_bufchan_d[0])),
                         (ss_d[0] || (s_d[0] || s_bufchan_d[0])),
                         (sss_d[0] || (ss_d[0] || ss_bufchan_d[0])),
                         (ssss_d[0] || (sss_d[0] || sss_bufchan_d[0])),
                         (sssss_d[0] || (ssss_d[0] || ssss_bufchan_d[0])),
                         (res0_d[0] || (rres0_d[0] || rres0_bufchan_d[0])),
                         (res1_d[0] || (rres1_d[0] || rres1_bufchan_d[0])),
                         (res2_d[0] || (rres2_d[0] || rres2_bufchan_d[0])),
                         (res3_d[0] || (rres3_d[0] || rres3_bufchan_d[0]))});
  `endif
endmodule
