//`include "Types.sv"

module Bram(
	    input logic 	clk,
	    input 		Cmd_t input_d,
	    output logic 	input_r,
	    output 		Res_t output_dout,
	    input logic 	output_rout,
	    //output logic [NODE_MSB-1:0] c0a_mem[2**POINTER_MSB-1:0]
	    input logic [11:0] 	bram_addr,
	    output logic [24:0] bram_line
	    );
  /* --define=INPUTS=((input, 50, 1125899906842624, Cmd)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((output, 34, 17179869184, Res)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   assign bram_line = c0a_mem[bram_addr];
   
   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter RES_MSB = NODE_BITS; //34;
   parameter NODE_MSB = NODE_BITS-1; //33;
   parameter CMD_MSB = POINTER_BITS+NODE_BITS-1; //50;
   parameter CMD_NODE_LSB = POINTER_BITS+1; //18;
   parameter CMD_WORD_MSB = POINTER_BITS; //17;
   
  Cmd_t c0_d;
  logic c0_r;
  Cmd_t c0a_d;
  logic c0a_r;
  Res_t c1_d;
  logic c1_r;
  Res_t c2_d;
  logic c2_r;
  Res_t output_d;
  logic output_r;
  
  /* source (Ty Cmd) : > (input,Cmd) */
  
  /* rbuf (Ty Cmd) : (input,Cmd) > (c0,Cmd) */
  Cmd_t input_buf;
  initial input_buf = {{CMD_MSB{1'bx}}, 1'd0};
  assign input_r = (! input_buf[0]);
  assign c0_d = (input_buf[0] ? input_buf :
                 input_d);
  always_ff @(posedge clk)
    if ((c0_r && input_buf[0])) input_buf <= {{CMD_MSB{1'bx}}, 1'd0};
    else if (((! c0_r) && (! input_buf[0]))) input_buf <= input_d;
  
  /* dbuf (Ty Cmd) : (c0,Cmd) > (c0a,Cmd) */
  initial c0a_d = {{CMD_MSB{1'bx}}, 1'd0};
  assign c0_r = ((! c0a_d[0]) || c0a_r);
  always_ff @(posedge clk)
    if (c0_r) c0a_d <= c0_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((c0a_d[0] && (! c0a_r))) $display("%5t blocked: c0a", $time);
  `endif
  
  /* bram (Ty Cmd,Ty Res) : (c0a,Cmd) > (c1,Res) */
  //logic [11:0] c0a_mem[4095:0];
  logic [NODE_MSB-1:0] c0a_mem[2**POINTER_MSB-1:0];
  logic [POINTER_MSB-1:0] c0a_address;
  logic [NODE_MSB-1:0] c0a_din;
  logic [NODE_MSB-1:0] c1_q;
  logic c1_valid;
  logic c0a_we;
  logic c1_we;
  assign c0a_din = c0a_d[CMD_MSB:CMD_NODE_LSB];
  assign c0a_address = c0a_d[CMD_WORD_MSB:2];
  assign c0a_we = (c0a_d[1:1] && c0a_d[0]);
  always_ff @(posedge clk)
    if (c0a_r)
      begin
        c1_we <= c0a_we;
        c1_valid <= c0a_d[0];
        if (c0a_we)
          begin
            c0a_mem[c0a_address] <= c0a_din;
            c1_q <= c0a_din;
          end
        else c1_q <= c0a_mem[c0a_address];
      end
  assign c1_d = {c1_q, c1_we, c1_valid};
  assign c0a_r = ((! c1_valid) || c1_r);
  
  /* dbuf (Ty Res) : (c1,Res) > (c2,Res) */
  initial c2_d = {{RES_MSB{1'bx}}, 1'd0};
  assign c1_r = ((! c2_d[0]) || c2_r);
  always_ff @(posedge clk)
    if (c1_r) c2_d <= c1_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((c2_d[0] && (! c2_r))) $display("%5t blocked: c2", $time);
  `endif
  
  /* rbuf (Ty Res) : (c2,Res) > (output,Res) */
  Res_t c2_buf;
  initial c2_buf = {{RES_MSB{1'bx}}, 1'd0};
  assign c2_r = (! c2_buf[0]);
  assign output_d = (c2_buf[0] ? c2_buf :
                     c2_d);
  always_ff @(posedge clk)
    if ((output_r && c2_buf[0])) c2_buf <= {{RES_MSB{1'bx}}, 1'd0};
    else if (((! output_r) && (! c2_buf[0]))) c2_buf <= c2_d;
  
  /* sink (Ty Res) : (output,Res) > */
  assign {output_r, output_dout} = {output_rout, output_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [1:0] bufferedChannelValids;
  logic [1:0] bufferedChannelReadys;
  logic [1:0] last1BufferedChannelValids;
  logic [1:0] last1BufferedChannelReadys;
  logic [1:0] last2BufferedChannelValids;
  logic [1:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 2'd0;
  initial last1BufferedChannelReadys = 2'd0;
  initial last2BufferedChannelValids = 2'd1;
  initial last2BufferedChannelReadys = 2'd1;
  assign bufferedChannelValids = {c0_d[0], output_d[0]};
  assign bufferedChannelReadys = {c0_r, output_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((c0_d[0] && (! c0_r))) $display(" blocked c0");
          if ((output_d[0] && (! output_r))) $display(" blocked output");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake c0:rbuf */
  /* wake c0a:dbuf */
  /* wake c2:dbuf */
  /* wake output:rbuf */
  always_ff @(posedge clk)
    $display("wake %b", {(c0_d[0] || input_d[0]),
                         (c0a_d[0] || c0_d[0]),
                         (c2_d[0] || c1_d[0]),
                         (output_d[0] || c2_d[0])});
  `endif
endmodule
