#include <stdio.h>
#include "Vprocessor.h"

#ifndef _UTILS_H_
#define _UTILS_H_

#define PROC(x) processor__DOT__ ## x
#define VCPU(x) processor__DOT__c__DOT__ ## x

#define S_FETCH 0
#define S_EXECUTE 1
#define S_EXECUTE2 2

void print_arr(SData *arr, int len) {
    for(int i = 0;i < len; ++i)
        fprintf(stderr, "%04x ", arr[i]);
}

void print_mem(CData *arr, int len) {
    for(int i = 0;i < len; ++i)
        fprintf(stderr, "%02x ", arr[i]);
}

void print_registers(Vprocessor *tb) {
    fprintf(stderr,
            "Misc. registers: state=%02x counter=%02x, N=%02x X=%02x I=%02x D=%02x\n",
            tb->processor__DOT__c__DOT__state,
            tb->processor__DOT__c__DOT__clock_counter,
            tb->processor__DOT__c__DOT__N_register,
            tb->processor__DOT__c__DOT__X_register,
            tb->processor__DOT__c__DOT__I_register,
            tb->processor__DOT__c__DOT__D_register);

    fprintf(stderr, "R_registers: ");
    print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
}

void print_state(Vprocessor *tb) {
    print_registers(tb);
    fprintf(stderr, "\nMemory: ");
    print_mem(tb->processor__DOT__m__DOT__mem, 32);
    fprintf(stderr, "\n");
}

void clock_cycle(Vprocessor *tb) {
    tb->clk = 0;
    tb->eval();
    tb->clk = 1;
    tb->eval();
}

void machine_cycle(Vprocessor *tb) {
    for (int i = 0; i < 3; i++) {
        clock_cycle(tb);
    }
}

#endif
