#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Vprocessor.h"
#include "verilated.h"
#include "verilator_test.h"


#define PROC processor__DOT_

void print_arr(SData *arr, int len) {
    for(int i = 0;i < len; ++i)
        printf("%04x ", arr[i]);
}

void print_mem(CData *arr, int len) {
    for(int i = 0;i < len; ++i)
        printf("%02x ", arr[i]);
}

void print_registers(Vprocessor *tb) {
    printf("Misc. registers: state=%02x N=%02x X=%02x I=%02x D=%02x\n",
            tb->processor__DOT__c__DOT__state,
            tb->processor__DOT__c__DOT__N_register,
            tb->processor__DOT__c__DOT__X_register,
            tb->processor__DOT__c__DOT__I_register,
            tb->processor__DOT__c__DOT__D_register);

    printf("R_registers: ");
    print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
}

void print_state(Vprocessor *tb) {
    print_registers(tb);
    printf("\nMemory: ");
    print_mem(tb->processor__DOT__m__DOT__mem, 32);
    printf("\n");
}

int main(int argc, char *argv[])
{
    const unsigned char prgrm[32] = {0xF8, 0x1F, 0xA3, 0xE3, 0xF8, 0x13, 0x73, 0xFF, 0x01, 0x3A, 0x06, 0x00};
    Verilated::commandArgs(argc, argv);

    Vprocessor *tb = new Vprocessor;

    memcpy(tb->processor__DOT__m__DOT__mem, prgrm, 32);

    printf("Initial state\n--------------------------\n");
    print_state(tb);
    printf ("\n\n");

    while(!Verilated::gotFinish()) {
        tb->clk = 1;
        //tb->processor__DOT__m__DOT__mem[1] = 0x0102;
        //tb->processor__DOT__c__DOT__R_registers[1] = 1;
        //tb->processor__DOT__c__DOT__I_register = 0;
        //tb->processor__DOT__c__DOT__N_register = 1;
        tb->eval();
        printf("Clock up\n--------------------------\n");
        print_state(tb);
        //printf("address_to_cpu: %04x\n", tb->processor__DOT__address_to_cpu);
        printf("address_from_cpu: %04x\n", tb->processor__DOT__address_from_cpu);
        printf("bus_from_cpu clock up: %04x\n", tb->processor__DOT__bus_from_cpu);
        printf("bus_to_cpu clock up: %04x\n", tb->processor__DOT__bus_to_cpu);
        //printf("ack_w clock up: %04x\n", tb->processor__DOT__ack_w);
        printf("ram_we clock up: %02x\n", tb->processor__DOT__ram_we);
        printf ("\n\n");
        tb->clk = 0;
        tb->eval();

#ifdef __PRINT_DOWN__
        printf("N_register clock down: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("X_register clock down: %02x\n", tb->processor__DOT__c__DOT__X_register);
        printf("I_register clock down: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("D_register clock down: %02x\n", tb->processor__DOT__c__DOT__D_register);
        printf("R_registers clock down: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
#endif

        printf("Press any key to move to next clock cycle\n");
        getchar();
    }
    return 0;
}
