#!/bin/bash

assembler="../A18/a18"
asmdir="./binaries"
listdir="./"

printferr() { printf "%b\n" "$*" >&2;}

main() {
    if [ ! -x "$assembler" ];then
        printferr "Error: A18 assembler is not available. Make sure to init git submodules and compile A18 with make"
        exit 1
    fi

    if [ $# -eq 0 ];then
        echo "Usage: $0 <assembly files to assemble>"
        exit
    fi

    local dir
    for dir in "$asmdir" "$listdir";do
        if [ ! -d "$dir" ];then
            printferr "Output directory '$dir' does not exist. Creating directory."
            mkdir -p "$dir"
        fi
    done
    unset dir

    local arg
    for arg in "$@";do
        if [ ! -f "$arg" ];then
            printferr "\e[31mFile '$arg' does not exist; skipping.\e[0m" 
            continue
        fi
        local barg="${arg##*/}"
        echo -e "----------------- Assembling file: $arg -----------------\n"
        "$assembler" "$arg" -b "$asmdir/${barg%.*}.bin" -l "$listdir/${barg%.*}.prn" >/dev/null \
            || printferr "\e[31mFile assembled with errors reported. Check listings file for info.\e[0m"
    done
}

main "$@"
