#!/bin/bash

# File: LINK.SH
# Compiles the .vsc file into LLVM ir,
# then static compiles with llc-5.0,
# then links in utils.cpp to finally generate executable

for var in "$@"
do
    basename=`echo $var | sed 's/.*\\///
                             s/.vsc//'`
    rm ${basename}.ir;
    rm ${basename}.exe;
    ./vscode.native $var.vsc >> ${basename}.ir;
    llc-5.0 ${basename}.ir;
    clang++-4.0 `pkg-config --cflags opencv` `pkg-config --libs opencv` ${basename}.ir.s utils.cpp -o ${basename}.exe
done
