/*
(*
  Allie Costa
  Laura Smerling
  Jacob Penn
  Laura Matos
*)
*/

/* Ocamlyacc parser for MicroC */

%{
open Ast
%}

%token SEMI COLON LPAREN RPAREN LBRACE RBRACE LBRACK RBRACK COMMA DATA NODE_LEVEL PLUS MINUS TIMES MOD DIVIDE ASSIGN
%token NOT EQ NEQ LT LEQ GT GEQ AND OR FUN
%token RETURN IF THEN ELSE FOR WHILE BFS DFS
%token INT BOOL FLOAT VOID STRING NODE PARENT
%token LSHIFT_NODE RSHIFT_NODE SWAP_NODE ADD_NODE REMOVE_NODE FIND_NODE
%token <int> LITERAL
%token <bool> BLIT
%token <string> ID FLIT
%token EOF

%start program
%type <Ast.program> program

%nonassoc FUN NOELSE 
%nonassoc ELSE SEMI COLON 
%right ASSIGN
%left PARENT
%left DATA NODE_LEVEL
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE MOD
%right NOT 
%left LSHIFT_NODE RSHIFT_NODE ADD_NODE REMOVE_NODE SWAP_NODE FIND_NODE
%%

program:
        item_list EOF { List.rev $1 }

item_list:
	{[]}
|	item_list item  {$2 :: $1}


item:
        stmt { Stmt($1) }
      | fdecl { Function($1) } 


typ:
    INT   { Int   }
  | BOOL  { Bool  }
  | FLOAT { Float }
  | VOID  { Void  }
  | STRING { String }
  | NODE LT typ GT { Node($3) }

 stmt_list:
      stmt { [$1] } 
    | stmt_list stmt { ($2 :: $1) } 

stmt:
    expr SEMI                               { Expr($1)              }
  | RETURN expr SEMI                        { Return ($2)           }
  | IF LPAREN expr RPAREN THEN LBRACE stmt_list RBRACE ELSE LBRACE stmt_list RBRACE { If($3, Seq($7),Seq($11))        }
  | typ ID ASSIGN expr SEMI 				{VarDec(($1, $2), $4)} 
  | FOR LPAREN expr SEMI expr SEMI expr RPAREN LBRACE stmt_list RBRACE { For($3, $5, $7, Seq($10))   }
  | WHILE LPAREN expr RPAREN LBRACE stmt_list RBRACE           { While($3, Seq($6))         }

expr:
    LITERAL          { Literal($1)            }
  | FLIT	           { Fliteral($1)           }
  | BLIT             { BoolLit($1)            }
  | ID               { Id($1)                 }
  | expr PLUS   expr { Binop($1, Add,   $3)   }
  | expr MINUS  expr { Binop($1, Sub,   $3)   }
  | expr TIMES  expr { Binop($1, Mult,  $3)   }
  | expr MOD    expr { Binop($1, Mod,   $3)   }
  | expr DIVIDE expr { Binop($1, Div,   $3)   }
  | expr EQ     expr { Binop($1, Equal, $3)   }
  | expr NEQ    expr { Binop($1, Neq,   $3)   }
  | expr LT     expr { Binop($1, Less,  $3)   }
  | expr LEQ    expr { Binop($1, Leq,   $3)   }
  | expr GT     expr { Binop($1, Greater, $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3)   }
  | expr AND    expr { Binop($1, And,   $3)   }
  | expr OR     expr { Binop($1, Or,    $3)   }
  | MINUS expr %prec NOT { Unop(Neg, $2)      }
  | NOT expr         { Unop(Not, $2)          }
  | ID ASSIGN expr   { Assign($1, $3)         }
  | ID LPAREN actuals_opt RPAREN { FunCall($1, $3)  }
  | LPAREN expr RPAREN { $2                   }

/* Node Auxillary*/
/*
  | expr DATA { NodeData($1) }
  | expr DATA ASSIGN expr { Assign(NodeData($1), $4)}
  | expr PARENT ASSIGN expr { Assign(NodeParent($1), $4) }
  | expr PARENT { NodeParent($1) }
  | LBRACK expr COMMA expr RBRACK { NodeLit($2, $4) }
  | expr NODE_LEVEL { NodeLevel($1) }
  | expr LSHIFT_NODE { LNodeShift($1)}
  | expr RSHIFT_NODE { RNodeShift($1)}
  | expr SWAP_NODE expr { SwapNode($1, $3) }
  | expr FIND_NODE LPAREN expr RPAREN { FindNode($1, $4) }
  | expr ADD_NODE LPAREN expr RPAREN { AddNode($1, $4) }
  | expr REMOVE_NODE LPAREN expr RPAREN { RemoveNode($1, $4) }
 
*/
fdecl:
   FUN typ ID LPAREN formal_opt RPAREN LBRACE stmt_list RBRACE
   { { typ = $2; 
       fname = $3;
       formals = $5;
       body = List.rev $8;
    } }

actuals_opt:
     /* nothing */ { [] }
     | actuals_list { List.rev $1 } 

actuals_list:
        expr    { [$1] }
    | actuals_list COMMA expr { $3 :: $1 } 
     
formal_opt:
       /* nothing */ { [] }
   | formal_list { List.rev $1 } 

formal_list:
     typ ID { [($1,$2)]}
  | formal_list COMMA typ ID { ($3,$4) :: $1 } 


