//Reference: https://www.sanfoundry.com/c-program-find-inverse-matrix/
#include<stdio.h>
#include<stdlib.h>
#include<math.h>

double determinant(double*, int);
double* cofactor(double*, int);
double* transpose(double*, double*, int);
double* inverse(double*, int);

/*For calculating Determinant of the Matrix */
double determinant(double* a, int k)
{
  double s = 1, det = 0;
  double *b;
  int i, j, m, n, c;
  b = malloc(k * k * sizeof(double));
  if (k == 1)
    {
     return (*a);
    }
  else
    {
     det = 0;
     for (c = 0; c < k; c++)
       {
        m = 0;
        n = 0;
        for (i = 0;i < k; i++)
          {
            for (j = 0 ;j < k; j++)
              {
                *(b + i*k + j) = 0;
                if (i != 0 && j != c)
                 {
                   *(b + m*k + n) = *(a + i*k + j);
                   if (n < (k - 2))
                    n++;
                   else
                    {
                     n = 0;
                     m++;
                     }
                   }
               }
             }
          det = det + s * ((*(a + 0*k + c)) * determinant(b, k - 1));
          s = -1 * s;
          }
    }
    free(b);
    return (det);
}

double norm1(double* numbers, int rows, int columns) {
  double res=0;
  for (int j = 0; j < columns; j ++) {
    double sum = 0;
    for (int i = 0; i < rows; i ++) {
      sum += fabs(numbers[i * columns + j]);
    }
    if (sum > res) res = sum;
  }
  return res;
}

double* matMul(double* a, int rows, int columns, double* b) {
  double* res = malloc(rows*sizeof(double));
  for (int i = 0; i < rows; i ++) {
    res[i] = 0;
    for (int k = 0; k < rows; k ++) {
      res[i] += a[i * columns + k] * b[k];
    }
  }
  return res;
}

double* transpose2(double* numbers, int rows, int columns) {
  double* trans = malloc(rows * columns * sizeof(double));
  for (int i = 0; i < rows; i ++) {
    for (int j = 0; j < columns; j ++) {
      trans[j * rows + i] = numbers[i * columns + j];
    }
  }
  return trans;
}

double max_eigvalue(double* numbers, int rows, int columns) {
  double* initVec = malloc(rows*sizeof(double));
  double max = 0;
  initVec[0] = 1;
  for (int i = 1; i < rows; i ++) initVec[i] = 0;
  for (int j = 0; j < 10000; j ++) {
    max = fabs(initVec[0]);
    for (int i = 1; i < rows; i ++) {
      if (max < fabs(initVec[i])) max = fabs(initVec[i]);
    }
    if (max != 0) {
      for (int i = 0; i < rows; i ++) {
        initVec[i] = initVec[i] / max;
      }
    }
    initVec = matMul(numbers, rows, columns, initVec);
  }
  return max;
}

double norm2(double* numbers, int rows, int columns) {
  if (rows == 1) {
    double res = 0;
    for (int i = 0; i < columns; i ++) {
      res += numbers[i] * numbers[i];
    }
    return sqrt(res);
  }
  double* trans = transpose2(numbers, rows, columns);
  double* m = malloc(rows * rows * sizeof(double));
  for (int i = 0; i < rows; i ++) {
    for (int j = 0; j < rows; j ++) {
      m[i * rows + j] = 0;
      for (int k = 0; k < columns; k ++) {
        m[i * rows + j] += numbers[i * columns + k] * numbers[k * rows + j]; 
      }
    }
  }
  return sqrt(max_eigvalue(m, rows, rows));
}

double* cofactor(double *num, int f)
{
 double *b, *fac;
 int p, q, m, n, i, j;
 b = malloc(f * f * sizeof(double));
 fac = malloc(f * f * sizeof(double));
 for (q = 0;q < f; q++)
 {
   for (p = 0;p < f; p++)
    {
     m = 0;
     n = 0;
     for (i = 0;i < f; i++)
     {
       for (j = 0;j < f; j++)
        {
          if (i != q && j != p)
          {
            *(b + m*f + n) = *(num + i*f + j);
            if (n < (f - 2))
             n++;
            else
             {
               n = 0;
               m++;
               }
            }
        }
      }
      *(fac + q*f + p) = pow(-1, q + p) * determinant(b, f - 1);
    }
  }
  free(b);
  return transpose(num, fac, f);
}
/*Finding transpose of matrix*/
double* transpose(double *num, double* fac, int r)
{
  int i, j;
  double *b, *inverse;
  double d;

  b = malloc(r * r * sizeof(double));
  inverse = malloc(r * r * sizeof(double));

  for (i = 0;i < r; i++)
    {
     for (j = 0;j < r; j++)
       {
         *(b + i*r + j) = *(fac + j*r + i);
        }
    }
  d = determinant(num, r);
  for (i = 0;i < r; i++)
    {
     for (j = 0;j < r; j++)
       {
        *(inverse + i*r + j) = (*(b + i*r + j)) / d;
        }
    }
    free(b);
    free(fac);
    return inverse;
}

double* inverse(double *m, int k) {
  double* invert;
  double d = determinant(m, k);
  if (d == 0) {
    printf("\nInverse of Entered Matrix is not possible\n");
    invert = NULL;
  }  else
    invert = cofactor(m, k);
  return invert;
}

#ifdef BUILD_TEST
int main()
{
  double* arr;
  double* invert;
  int i, j, r;
  r = 2;
  arr = malloc(2 * 2 * sizeof(double));
  *(arr + 0) = 1;
  *(arr + 1) = 2;
  *(arr + 2) = 3;
  *(arr + 3) = 4;
  invert = inverse(arr, 2);
   printf("The inverse of matrix is : \n");

   for (i = 0;i < r; i++)
    {
     for (j = 0;j < r; j++)
       {
         printf("\t%lf", *(invert + i*r + j));
        }
    printf("\n");
     }

}
#endif
