/*
    Standard Library for Casper
    Based on MicroC printbig.c
    File: stdlib.c
    Michael Makris, mm3443
    PLT Fall 2018
*/
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

/* String functions for operators */
char *concats(char *s1, char *s2) { /* String _ String */        
    char *answer = (char *) malloc(strlen(s1) + strlen(s2) + 1);
    strcpy(answer, s1);
    strcat(answer, s2);
    return answer;
}

char *concati(char *s1, int x) { /* String _ int */        
    int length = snprintf( NULL, 0, "%d", x );
    char* s2 = malloc( length + 1 );
    snprintf(s2, length + 1, "%d", x);
        
    char *answer = (char *) malloc(strlen(s1) + strlen(s2) + 1);
    strcpy(answer, s1);
    strcat(answer, s2);
    return answer;
}

char *concatf(char *s1, double f) { /* String _ float */        
    int length = snprintf( NULL, 0, "%g", f );
    char* s2 = malloc( length + 1 );
    snprintf(s2, length + 1, "%g", f);
        
    char *answer = (char *) malloc(strlen(s1) + strlen(s2) + 1);
    strcpy(answer, s1);
    strcat(answer, s2);
    return answer;
}

char *concatb(char *s1, int x) { /* String _ bool */        
    char *s2 = "false";
    
    if (x == 1) s2 = "true";

    char *answer = (char *) malloc(strlen(s1) + strlen(s2) + 1);
    strcpy(answer, s1);
    strcat(answer, s2);
    return answer;
}

char *charat(char *s, int i) {
    char *answer = (char *) malloc(2);
    answer[0] = s[i]; answer[1] = '\0';
    return answer;
}

int scomp(char *s1, char *s2, int i) {
    int answer = 0;
    int comp = strcmp(s1, s2);
    switch (i) { 
        case 1:   /* Eql */
            answer = (comp == 0);
            break;
        case 2:   /* Neq */ 
            answer = (comp != 0);
            break;
        case 3:   /* Lst */
            answer = (comp < 0);            
            break;
        case 4:   /* Lse */
            answer = (comp <= 0);            
            break;
        case 5:   /* Grt */
            answer = (comp > 0);            
            break;
        case 6:   /* Gre */
            answer = (comp >= 0);            
            break;            
    }
    if (answer != 0) answer = 1;

    return answer;
}

void printb(int b, int nl){
    if(b){
      if(nl) printf("%s\n", "true");
      else printf("true");
    } else {
      if(nl) printf("%s\n", "false");
      else printf("false");
    }
}

/*
 *  A function illustrating how to link C code to code generated from LLVM 
 * Font information: one byte per row, 8 rows per character
 * In order, space, 0-9, A-Z
 */
static const char font[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0x3e, 0x61, 0x41, 0x43, 0x3e, 0x1c, 0x00,
  0x00, 0x40, 0x42, 0x7f, 0x7f, 0x40, 0x40, 0x00,
  0x62, 0x73, 0x79, 0x59, 0x5d, 0x4f, 0x46, 0x00,
  0x20, 0x61, 0x49, 0x4d, 0x4f, 0x7b, 0x31, 0x00,
  0x18, 0x1c, 0x16, 0x13, 0x7f, 0x7f, 0x10, 0x00,
  0x27, 0x67, 0x45, 0x45, 0x45, 0x7d, 0x38, 0x00,
  0x3c, 0x7e, 0x4b, 0x49, 0x49, 0x79, 0x30, 0x00,
  0x03, 0x03, 0x71, 0x79, 0x0d, 0x07, 0x03, 0x00,
  0x36, 0x4f, 0x4d, 0x59, 0x59, 0x76, 0x30, 0x00,
  0x06, 0x4f, 0x49, 0x49, 0x69, 0x3f, 0x1e, 0x00,
  0x7c, 0x7e, 0x13, 0x11, 0x13, 0x7e, 0x7c, 0x00,
  0x7f, 0x7f, 0x49, 0x49, 0x49, 0x7f, 0x36, 0x00,
  0x1c, 0x3e, 0x63, 0x41, 0x41, 0x63, 0x22, 0x00,
  0x7f, 0x7f, 0x41, 0x41, 0x63, 0x3e, 0x1c, 0x00,
  0x00, 0x7f, 0x7f, 0x49, 0x49, 0x49, 0x41, 0x00,
  0x7f, 0x7f, 0x09, 0x09, 0x09, 0x09, 0x01, 0x00,
  0x1c, 0x3e, 0x63, 0x41, 0x49, 0x79, 0x79, 0x00,
  0x7f, 0x7f, 0x08, 0x08, 0x08, 0x7f, 0x7f, 0x00,
  0x00, 0x41, 0x41, 0x7f, 0x7f, 0x41, 0x41, 0x00,
  0x20, 0x60, 0x40, 0x40, 0x40, 0x7f, 0x3f, 0x00,
  0x7f, 0x7f, 0x18, 0x3c, 0x76, 0x63, 0x41, 0x00,
  0x00, 0x7f, 0x7f, 0x40, 0x40, 0x40, 0x40, 0x00,
  0x7f, 0x7f, 0x0e, 0x1c, 0x0e, 0x7f, 0x7f, 0x00,
  0x7f, 0x7f, 0x0e, 0x1c, 0x38, 0x7f, 0x7f, 0x00,
  0x3e, 0x7f, 0x41, 0x41, 0x41, 0x7f, 0x3e, 0x00,
  0x7f, 0x7f, 0x11, 0x11, 0x11, 0x1f, 0x0e, 0x00,
  0x3e, 0x7f, 0x41, 0x51, 0x71, 0x3f, 0x5e, 0x00,
  0x7f, 0x7f, 0x11, 0x31, 0x79, 0x6f, 0x4e, 0x00,
  0x26, 0x6f, 0x49, 0x49, 0x4b, 0x7a, 0x30, 0x00,
  0x00, 0x01, 0x01, 0x7f, 0x7f, 0x01, 0x01, 0x00,
  0x3f, 0x7f, 0x40, 0x40, 0x40, 0x7f, 0x3f, 0x00,
  0x0f, 0x1f, 0x38, 0x70, 0x38, 0x1f, 0x0f, 0x00,
  0x1f, 0x7f, 0x38, 0x1c, 0x38, 0x7f, 0x1f, 0x00,
  0x63, 0x77, 0x3e, 0x1c, 0x3e, 0x77, 0x63, 0x00,
  0x00, 0x03, 0x0f, 0x78, 0x78, 0x0f, 0x03, 0x00,
  0x61, 0x71, 0x79, 0x5d, 0x4f, 0x47, 0x43, 0x00
};

void printbig(int c)
{
  int index = 0;
  int col, data;
  if (c >= '0' && c <= '9') index = 8 + (c - '0') * 8;
  else if (c >= 'A' && c <= 'Z') index = 88 + (c - 'A') * 8;
  do {
    data = font[index++];
    for (col = 0 ; col < 8 ; data <<= 1, col++) {
      char d = data & 0x80 ? 'X' : ' ';
      putchar(d); putchar(d);
    }
    putchar('\n');
  } while (index & 0x7); 
}

/* #define BUILD_TEST */
#ifdef BUILD_TEST
int main()
{
  char s[] = "HELLO WORLD09AZ";
  char *c;
  for ( c = s ; *c ; c++) printbig(*c);
}
#endif
