#!/bin/bash
# View clang llvm output
# File: clangviz.sh
# Michael Makris, mm3443
# PLT Fall 2018

echo "usage: ./clangviz.sh <C program filename with no extension>"

echo "---> running clang  --->"
clang -emit-llvm -S -c $1.c -o - > $1.ll

echo "---> running opt  --->"
opt -dot-cfg $1.ll

echo "---> main() control-flow graph --->"
dot -Tpng cfg.main.dot > $1.png

echo "---> cleanup --->"
rm cfg.main.dot $1.ll

echo "---> see" $1.png
