#!/bin/bash
# Compile and run programs for Casper
# create png of main and other ll dot files for debugging
# File: casperll.sh
# Michael Makris, mm3443
# PLT Fall 2018

echo "usage: ./casperll.sh <program filename with no extension>"
echo
echo "---> running casper.native           --->"
echo "---> COMPILE ERRORS COME NEXT        --->"
./casper.native < $1.goo > $1.ll
echo
echo "---------------------------------------->"
echo "---> llc command                     --->"
llc -relocation-model=pic $1.ll > $1.s

echo "---> compiling stdlib object file    --->"
cc -c -Wall stdlib.c
echo "---> linking files                   --->"
cc -o $1.exe $1.s stdlib.o -lm

echo "---> main() control-flow graph       --->"
opt -dot-cfg $1.ll
dot -Tpng cfg.main.dot > $1.png
echo "---> see" $1.png "--->"
echo "---> running executable" $1.exe " --->"
echo
./$1.exe

