type token =
  | PLUS
  | MINUS
  | MULTIPLY
  | DIVIDE
  | MODULO
  | ELEM_PLUS
  | ELEM_MINUS
  | ELEM_MULTIPLY
  | ELEM_DIVIDE
  | ELEM_MODULO
  | EQ
  | NEQ
  | GEQ
  | LEQ
  | AND
  | OR
  | NOT
  | XOR
  | BIT_AND
  | BIT_OR
  | BIT_XOR
  | BIT_LS
  | BIT_RS
  | BIT_NOT
  | ASSIGN
  | PRODUCES
  | PIPE
  | LBRACE
  | RBRACE
  | LBRACKET
  | RBRACKET
  | LPAREN
  | RPAREN
  | SEMI
  | COLON
  | COMMA
  | PERIOD
  | FOR
  | IN
  | IF
  | ELSE
  | RETURN
  | INT
  | FLOAT
  | CHAR
  | FUN
  | STRUCT
  | STRING
  | TUP
  | LIST
  | MATRIX
  | LENGTH
  | SIZE
  | DIMS
  | ROWS
  | COLS
  | NUM_ROWS
  | NUM_COLS
  | MAP
  | FREAD
  | FWRITE
  | PRINT
  | RANGE
  | TOFL
  | TOINT
  | TRUE
  | FALSE
  | INT_LIT of (Ast.scalar)
  | FLOAT_LIT of (Ast.scalar)
  | CHAR_LIT of (char)
  | STRING_LIT of (string)
  | ID of (string)
  | EOF

val program :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast.program
