import sys
import pdb

def main():
	""" Intended to be called with 'python move_scan <test_name>'.
	Finds the file '../pass/_<test_name>.res', flattens it to one line,
	and moves it to ../../parser/pass as '_<test_name>.test'
	"""
	# Validate inputs
	args = sys.argv
	if len(sys.argv) !=2:
		print("Must pass exactly 1 test name as input.\n")
		sys.exit(-1)
	# Determine file names from test name
	name = sys.argv[1]
	fname = "../pass/_" + name + ".res"
	outname = "../../parser/pass/_" + name + ".test"
	# Open input file
	with open(fname) as f:
		data = f.readlines()
		#pdb.set_trace()
		output = data[0][:-1]
		for line in data[1:]:
			output = output + " " + line[:-1]
		output = output+"\n"
		# Open output file and write output
		with open(outname, 'w') as out:
			out.write(output)
	sys.exit(0)

if __name__ == "__main__":
	main()
