type binop = Add   | Sub   | Mul   | Div   | Mod
           | ElAdd | ElSub | ElMul | ElDiv | ElMod
           | Eq    | Neq   | Geq   | Leq
           | And   | Or    | Xor | BitAnd | BitOr | BitXor | BitLs | BitRs
type unop = Not | Neg | BitNot | ToFl | ToInt | Print
type scalar = LitInt of int | LitFloat of float
type datatype = Int | Float | Char | Bool | String | Struct | Tup | Fun
              | List of datatype | Matrix of datatype | NoType

type stmt =
  Expr of expr
| Return of expr
| If of expr * stmt * stmt
| For of string * iterable * stmt
| Block of stmt list

and expr =
  NumLit of scalar
| CharLit of char
| StringLit of string
| BoolLit of bool
| StructLit of id_item list
| TupLit of expr list
| ListLit of expr list
| FunLit of arg list * datatype * stmt list
| MatrixLit of expr list list
| MatrixFunDef of scalar * scalar * func_item
| BinOp of expr * expr * binop
| UnOp of expr * unop
| Id of string
| Assign of expr * expr
| Attribute of expr * string
| Call of string * expr list
| Pipe of expr * expr

and id_item =
  IdItem of string
| IdAssign of expr * expr

and arg =
  ArgId of string * datatype
| ArgAssign of expr * datatype * expr

and func_item =
  FunId of string
| FunItem of arg list * datatype * stmt list

and iterable =
  ItId of string
| ItListLit of expr list
| ItMatrixLit of expr list list
| ItMatrixFunDef of scalar * scalar * func_item
| ItCall of string * expr list

type vardecl = {
    return_type : datatype;
    var_name    : string;
    body        : expr;
}

(* Start Symbol *)
type program = vardecl list
