module A = Ast
module S = Semant
module Ts = To_string

let assign_print expr = A.Assign({assign_name = "%scratch"; new_val = expr})

let vec_acc_err vec_name ind s = let neg = A.BinOp(ind, A.NumLit(A.LitInt(0)), A.Lt) in
	let too_big = A.BinOp(ind, A.Attribute(vec_name, "len"), A.Geq) in
	let bad_ind = A.BinOp(neg, too_big, A.Or) in
	let scratch_var = A.Decl({return_type = A.Int; var_name = "%scratch"; body = A.NumLit(A.LitInt(0))}) in
	let print_err = A.Call("print",[StringLit("Error - out of bounds index attempt on ")]) in
	let print_details = A.Call("print", [StringLit vec_name]) in
	let print_loc = A.Call("print", [StringLit(" at statement: " ^ Ts.string_of_stmt s)]) in
	let goto_err = A.Call("%err", []) in
	let print_exps = [print_err; print_details; print_loc] in
	let print_sts = List.map assign_print print_exps in
	A.If(bad_ind, scratch_var :: print_sts, [])

let rec mutate (env: S.translation_environment) s = 
	match s with
	| A.VecAssign(v) -> (match v.index with
		| A.MatIndex(ind) -> let err = vec_acc_err v.vec_name ind s in [err; s]
		(* | A.MatSlice(start, end) -> A.For(A.Call("range", start :: [end]) *)
		| _ -> [s]
	)
	| A.Decl(d) -> (match d.body with
		| A.FunLit(ftype, sts) -> [A.Decl({d with body = FunLit(ftype, recombine env sts)})]
		| A.VecAcc(vname, ind) -> (match ind with
			| A.MatIndex(ind) -> let err = vec_acc_err vname ind s in [err; s]
			(* | A.MatSlice(start, end) -> A.For(A.Call("range", start :: [end]) *)
			| _ -> [s]
		)
		| _ -> [s]
	)
	| _ -> [s]

(* Check a whole program, statement by statement, for semantic correctness *)
and recombine (env: S.translation_environment) stmt_list =
	match stmt_list with
	| [] -> []
	| h :: t -> (mutate env h) @ (recombine env t)

let splice prog_tree = 
	let global_scope = S.get_init_scope in
	let global_env: S.translation_environment = {scope = global_scope; loc_ret_type = BoolT} in
	recombine global_env prog_tree