#ifndef __UTIL_H_
#define __UTIL_H_ 

#include <arpa/inet.h>
#include <errno.h>
#include <netdb.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <unistd.h>

struct pak_header { 
    uint32_t ord;
    int jid;
    uint32_t len;
};

void die(const char * s);
int read_blk(int sock, void *b, size_t size);
int write_blk(int sock, void *b, size_t size);
int read_msg(int sock, struct pak_header *hdr, uint8_t **data);
int read_msg_combined(int sock, uint8_t **data);
int write_msg(int sock, struct pak_header hdr, uint8_t *data);
int client_connect(int *sock, const char *host, const char *port);
int start_server(int *s_sock, short port);
#endif /* __UTIL_H */
