#include "util.h"

void die(const char * s) 
{
    (errno) ? perror(s) : fprintf(stderr, "%s.\n", s); 
    exit(1); 
}

int op_blk(int s, void *b, size_t l, ssize_t(*f)(int, void *, size_t, int))
{
    while (l) {
        ssize_t bytes = f(s, b, l, 0);
        if (bytes <= 0)
            return -1;
        l -= bytes;
        b += bytes;
    }
    return 0;
}

int read_blk(int s, void *b, size_t l) { return op_blk(s, b, l, recv); }

int write_blk(int s, void *b, size_t l) 
{ 
    return op_blk(s, b, l, (ssize_t (*) (int, void *, size_t, int)) send); 
}

int read_msg(int sock, struct pak_header *hdr, uint8_t **data)
{
    return (((       read_blk(sock, hdr, sizeof *hdr)) < 0) ||
           ((*data = malloc(hdr->len)) == NULL) ||
           (((       read_blk(sock, *data, hdr->len)) < 0 ) && 
           (             free(*data), 1))) * -1;
}

int read_msg_combined(int sock, uint8_t **data)
{
    struct pak_header hdr;
    return (((       read_blk(sock, &hdr, sizeof hdr)) < 0) ||
           ((*data = malloc(hdr.len + sizeof hdr)) == NULL) ||
           (((       read_blk(sock, *data + sizeof hdr, hdr.len)) < 0 ) && 
           (             free(*data), 1)) ||
           (         *((struct pak_header *) *data) = hdr, 0)) * -1;
}

int write_msg(int sock, struct pak_header hdr, uint8_t *data)
{
    return ((write_blk(sock, &hdr, sizeof hdr) < 0) || 
           ( write_blk(sock, data, hdr.len) < 0)) * -1;
}

int client_connect(int *sock, const char *host, const char *port)
{
    struct addrinfo *r;
    return ((     getaddrinfo(host, port, &(struct addrinfo) {
                        .ai_family=AF_UNSPEC, 
                        .ai_socktype=SOCK_STREAM}, &r) != 0) ||
        ((*sock = socket(r->ai_family, r->ai_socktype, r->ai_protocol)) < 0)
        || ((     connect(*sock, r->ai_addr, r->ai_addrlen) < 0) && 
        (             close(*sock), freeaddrinfo(r), 1)) ||
        (         freeaddrinfo(r), 0));
}


int start_server(int *s_sock, short port)
{
    return (((*s_sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) ||
           (            setsockopt(*s_sock, SOL_SOCKET, SO_REUSEADDR, 
                                &(int){1}, sizeof(int)) < 0) || 
           (            bind(*s_sock, (struct sockaddr *) 
                                &(struct sockaddr_in) { 
                                    .sin_family = AF_INET, 
                                    .sin_addr.s_addr = htonl(INADDR_ANY),
                                    .sin_port = htons(port) },
                                sizeof(struct sockaddr_in)) < 0) || 
           (            listen(*s_sock, 0) < 0)) * -1;
}

