#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <math.h>

int j_gcd(int a, int b)
{
    if (a > b)
        return j_gcd(a-b, b);
    if (a < b)
        return j_gcd(a, b-a);
    return a;
}

int j_prime(int a)
{
    if (a < 2)
        return 0;
    int s = (int) sqrt(a);
    for (int i = 2; i <= s; i++)
        if (a % i == 0)
            return 0;
    return 1;
}

void s_gcd(uint8_t *in_d, uint32_t in_l, uint8_t **out_d, uint32_t *out_l)
{
    if (in_l != 2 * sizeof(int)) {
        *out_d = NULL;
        *out_l = 0;
        return;
    }
    *out_d = malloc(sizeof(int));
    *((int *)*out_d) = j_gcd(((int *)in_d)[0], ((int *)in_d)[1]);
    *out_l = sizeof(int);
}

void s_prime(uint8_t *in_d, uint32_t in_l, uint8_t **out_d, uint32_t *out_l)
{
    if (in_l % sizeof(int)) {
        *out_d = NULL;
        *out_l = 0;
        return;
    }
    *out_d = malloc(in_l);
    int num_primes = 0;
    for (int i = 0; i < in_l / sizeof(int); i++)
        if (j_prime(*(((int *)in_d) + i)))
            *(((int *)*out_d) + num_primes++) = *(((int *)in_d) + i);
    *out_d = realloc(*out_d, num_primes * sizeof(int));
    *out_l = num_primes * sizeof(int);
}

void (*job_funcs [])(uint8_t *, uint32_t, uint8_t **, uint32_t *) = {
    s_gcd, s_prime };
int num_jobs =  (sizeof(job_funcs) / sizeof(*job_funcs));
