#include "test_master.h"
#include <string.h>

#define NUMJOBS 1000
#define JOBSIZE 10000

int sum_ints(int *list, int num)
{
    int res = 0;
    for (int i = 0; i < num; i++)
        res += list[i];
    return res;
}

void master()
{
    int i1[] = {332114, 3562749};
    int *m_i1 = malloc(sizeof i1);
    memcpy(m_i1, i1, sizeof i1);
    int j1 = start_job(1, (uint8_t *) m_i1, sizeof i1);
    int primejobs[NUMJOBS];
    int *numsets[NUMJOBS];
    for (int i = 0; i < NUMJOBS; i++) {
        numsets[i] = malloc( JOBSIZE * sizeof(int));
        for (int j = 0; j < JOBSIZE; j++)
            numsets[i][j] = JOBSIZE * i + j;
        primejobs[i] = start_job(2, (uint8_t *) numsets[i], 
                JOBSIZE * sizeof(int));
    }
    int *primesets[NUMJOBS];
    uint32_t primelens[NUMJOBS];
    for (int i = 0; i < NUMJOBS; i++) {
        reap_job(primejobs[i], (uint8_t **) &primesets[i], &primelens[i]);
        /*if (i == 200)
            cancel_job(primejobs[NUMJOBS-1]);*/
        if (primesets[i]) {
            free(primesets[i]);
        } else
            printf("lost job %d\n", primejobs[i]);
    }
    for (int numsets = 1; numsets <= NUMJOBS; numsets *= 10)
        printf("Number of primes up to %d: %ld\n", numsets * JOBSIZE, 
            sum_ints((int *)primelens, numsets) / sizeof(int));
    int *gcd;
    uint32_t len;
    reap_job(j1, (uint8_t **)&gcd, &len);
    if (len == sizeof(int))
        printf("and the gcd of %d and %d is %d\n", i1[0], i1[1], *gcd);
    else
        printf("bad len from gcd\n");
    if (gcd)
        free(gcd);
}

