#ifndef __SLAVE_QUEUE_H_
#define __SLAVE_QUEUE_H_

#include <pthread.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define SLAVE_QUEUE_INITIALIZER { .lock = PTHREAD_MUTEX_INITIALIZER }

struct slave {
    int sock;
};

struct slave_queue {
    struct slave *slaves;
    pthread_t *threads;
    int len;
    int threadlen;
    int being_destroyed;
    pthread_mutex_t lock;
};

void slave_queue_add(struct slave_queue *sq, int sock);
void slave_queue_set_thread(struct slave_queue *sq, int sock, pthread_t th);
void slave_queue_remove(struct slave_queue *sq, int sock);
/*int slave_queue_assign_next(struct slave_queue *sq);
void slave_lock(struct slave_queue *sq, int sock);
void slave_unlock(struct slave_queue *sq, int sock);*/
void slave_queue_destroy(struct slave_queue *sq);

#endif /* __SLAVE_QUEUE_H_ */
