#include "slave_queue.h"
#include <stdio.h>

struct slave *slave_lookup(struct slave *beg, struct slave *end, int sock)
{
    struct slave *mid = beg + (end-beg)/2;
    if (mid == end) 
        return mid;
    if (mid->sock > sock && mid > beg)
        return slave_lookup(beg, mid, sock); 
    if (mid->sock < sock && mid + 1 == end)
        return mid + 1;
    if (mid->sock < sock)
        return slave_lookup(mid + 1, end, sock);
    return mid;
}

void slave_queue_add(struct slave_queue *sq, int sock) 
{
    if (sock < 0)
        return;
    pthread_mutex_lock(&sq->lock);
    struct slave *loc = slave_lookup(sq->slaves, sq->slaves+sq->len, sock);
    if ((loc != sq->slaves + sq->len) && (loc->sock == sock)) {
        pthread_mutex_unlock(&sq->lock);
        return;
    }
    if ((sq->len == 0) || !(sq->len & (sq->len - 1))) { /* power of 2 */
        int offset = loc - sq->slaves;
        sq->slaves = realloc(sq->slaves, ((sq->len) ? sq->len*2 : 1) 
                * sizeof(struct slave));
        loc = sq->slaves + offset;
        memmove(loc + 1, loc, (sq->slaves + sq->len - loc) * 
                sizeof(struct slave));
    }
    loc->sock = sock;
    sq->len++;
    pthread_mutex_unlock(&sq->lock);
}
void slave_queue_set_thread(struct slave_queue *sq, int sock, pthread_t th)
{
    pthread_mutex_lock(&sq->lock);
    sq->threads = realloc(sq->threads, ++sq->threadlen * sizeof(pthread_t));
    sq->threads[sq->threadlen-1] = th;
    pthread_mutex_unlock(&sq->lock);
}

void slave_queue_remove(struct slave_queue *sq, int sock) 
{
    while ( pthread_mutex_trylock(&sq->lock) != 0) {
        if (sq->being_destroyed)
            return;
        else 
            usleep(10000);
    }
    struct slave *loc = slave_lookup(sq->slaves, sq->slaves+sq->len, sock);
    if ((loc != sq->slaves + sq->len) && (loc->sock == sock)) {
        close(loc->sock);
        memmove(loc, loc + 1, (--sq->len - (loc - sq->slaves)) * 
                sizeof (struct slave));
        if (!(sq->len & (sq->len - 1)))
            sq->slaves=realloc(sq->slaves, sq->len * sizeof(struct slave));
    }
    pthread_mutex_unlock(&sq->lock);
}

void slave_queue_destroy(struct slave_queue *sq)
{
    pthread_mutex_lock(&sq->lock);
    sq->being_destroyed = 1;
    for (struct slave *s = sq->slaves; s != sq->slaves + sq->len; s++)
        close(s->sock);
    for (int i = 0; i < sq->threadlen; i++)
        pthread_join(sq->threads[i], NULL);
    if (sq->slaves)
        free(sq->slaves);
    if (sq->threads)
        free(sq->threads);
    *sq = (struct slave_queue) {0};
}
