#include "slave.h"

static pthread_mutex_t write_mutex = PTHREAD_MUTEX_INITIALIZER;
static int sock;

void *run_job(void *arg)
{
    pthread_detach(pthread_self());
    struct pak_header *hdr = (struct pak_header *) arg;
    uint8_t *out_data, *in_data = ((uint8_t *)arg) + sizeof *hdr;
    if (hdr->ord >= 1 && hdr->ord <= num_jobs) {
        job_funcs[hdr->ord - 1](in_data, hdr->len, &out_data, &hdr->len);
        pthread_mutex_lock(&write_mutex);
        write_msg(sock, *hdr, out_data);
        pthread_mutex_unlock(&write_mutex);
        if (out_data)
            free(out_data);
    }
    if (arg)
        free(arg);
    return NULL;
}

void slave()
{
    uint8_t *data;
    while (read_msg_combined(sock, &data) == 0)
        pthread_create(&(pthread_t){0}, NULL, &run_job, data);
}

int main(int argc, char **argv)
{   /* usage: ./slave [[HOST] PORT] */
    client_connect(&sock, (argc > 2) ? argv[1]              : "127.0.0.1",
                          (argc > 1) ? argv[1 + (argc > 2)] : "8888");
    slave();
    close(sock);        
    return 0;
}
