#include "master.h"

static volatile int should_die;
static struct slave_queue slave_q = SLAVE_QUEUE_INITIALIZER;
static struct job_list job_l = JOB_LIST_INITIALIZER;
static int s_sock;

int start_job(uint32_t ord, uint8_t *data, uint32_t len)
{
    int jid = job_add(&job_l, ord, data, len, 0, 2);
    job_enqueue(&job_l, jid);
    return jid;
}

void reap_job(int jid, uint8_t **data, uint32_t *len)
{
    while (job_status(&job_l, jid) >= 0)
        usleep(10000);
    job_remove(&job_l, jid, data, len);
}

int get_job_status(int jid) { return job_status(&job_l, jid); }

void cancel_job(int jid)
{
    int sock = job_remove(&job_l, jid, NULL, NULL);
    if (sock > 0) {
        int newjid = job_add(&job_l, -jid, NULL, 0, sock, 0);
        job_enqueue_front(&job_l, newjid);
    }
}

void *slave_feeder(void *arg)
{
    int sock = *((int *)arg);
    struct pak_header hdr;
    uint8_t *data;
    while (*((int *)arg)) {
        if (job_dequeue(&job_l, &hdr, &data, sock) < 0) {
            usleep(10000);
            continue;
        }
        job_set_socket(&job_l, hdr.jid, sock);
        if (write_msg(sock, hdr, data) < 0)
            break;
    }
    return NULL;
}

void *slave_return_collector(void *arg) {
    int sock = *((int *)arg);
    pthread_t feeder;
    pthread_create(&feeder, NULL, slave_feeder, arg);
    struct pak_header header;
    uint8_t *data;
    while (!should_die) {
        if (poll(&(struct pollfd){.fd=sock, .events=POLLIN}, 1, 0) <= 0) {
            if (should_die)
                break;
            else
                usleep(10000);
        } else {
            if (should_die || (read_msg(sock, &header, &data) < 0))
                break;
            job_add_data(&job_l, header.jid, data, header.len);
        }
    }
    *((int *)arg) = 0;
    pthread_join(feeder, NULL);
    job_socket_failed(&job_l, sock);
    slave_queue_remove(&slave_q, sock);
    free(arg);
    return NULL;
}

void *slave_acceptor(void *arg)
{
    while (!should_die) {
        if (poll(&(struct pollfd){.fd=s_sock, .events=POLLIN}, 1, 0) <= 0)
            usleep(10000);
        else {
            int *p_sock = malloc(sizeof(int));
            *p_sock = accept(s_sock, &(struct sockaddr){0}, 
                    &(socklen_t) { sizeof(struct sockaddr)});
            slave_queue_add(&slave_q, *p_sock);
            pthread_t th;
            pthread_create(&th, NULL, slave_return_collector, 
                p_sock);
            slave_queue_set_thread(&slave_q, *p_sock, th);
        }
    }
    return NULL;
}

int main(int argc, char **argv) 
{
    signal(SIGPIPE, SIG_IGN);
    if (start_server(&s_sock, (argc > 1) ? atoi(argv[1]) : 8888) < 0) {
        perror("could not start server");
        exit(1);
    }
    pthread_t accept_th;
    pthread_create(&accept_th, NULL, slave_acceptor, NULL);
    master();
    should_die = 1;
    pthread_join(accept_th, NULL);
    slave_queue_destroy(&slave_q);
    job_list_destroy(&job_l);
    close(s_sock);
    return 0;
}
