#ifndef __JOB_LIST_H_
#define __JOB_LIST_H_

#include <pthread.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"

#define JOB_LIST_INITIALIZER { .lock = PTHREAD_MUTEX_INITIALIZER }
#define JOB_UNASSIGNED 0
#define JOB_FINISHED -1
#define JOB_FAILED -2
#define JOB_LOST -3

struct job {
    int jid;
    int ord;
    uint32_t len;
    uint8_t *data;
    int sock;
    struct job *next;
    struct job *prev;
    int attempts;
};

struct job_list {
    struct job *jobs;
    struct job *first;
    struct job *last;
    int len;
    int next_jid;
    pthread_mutex_t lock;
};

int job_add(struct job_list *jl, int ord, uint8_t *data, uint32_t len, 
        int sock, int restart);
void job_enqueue(struct job_list *jl, int jid);
void job_enqueue_front(struct job_list *jl, int jid);
int job_dequeue(struct job_list *jl, struct pak_header *hdr, uint8_t **data,
        int sock);
void job_set_socket(struct job_list *jl, int jid, int sock);
void job_socket_failed(struct job_list *jl, int sock);
void job_add_data(struct job_list *jl, int jid, uint8_t *data, 
        uint32_t len);
int job_status(struct job_list *jl, int jid);
int job_remove(struct job_list *jl, int jid, uint8_t **data, 
        uint32_t *len);
void job_list_destroy(struct job_list *jl);

#endif /* __JOB_LIST_H_ */
