# M/s Compiler

Authors:
* Benjamin Hanser (bwh2124)
* Miranda Li (mjl2206)
* Mengdi Lin (ml3567)

COMS 4115, Programming Languages and Translators
Professor Stephen Edwards
May 10, 2017

---
M/s is a language for implementing a distributed system (master-slaves relationship). It allows a master server distribute work across slave nodes. The user defines the master function (akin to a main function), as well as job functions that can be run either locally or on slaves without worrying about socket handling, threading, and network packet serialization for their job inputs. Everything just works after the user has defined master and job functions!

## Key Features

M/s provides a default runtime that does socket handling, threading, and job scheduling. The code generation provides serialization and deserialization procedures for the inputs and outputs of user-defined job functions. We have removed the fuzziness that comes from manipulating data structures that contain pointers and references because all assignments of variables are copy assignments by default. All function arguments are passed by value. 

M/s supports C++-like data structure called vectors in place of C arrays, and also supports C-like structs. M/s has automatic garbage collection; once variables go out of scope, they will be cleaned up. What the users need to provide to M/s are simply the definitions of a master function (similar to C’s main function), and the definitions of job functions. 

The syntax of remote jobs mimic those of Java’s Futures: the remote keyword is a non-blocking operation used to submit a job to be run remotely. get keyword is a blocking operation used to retrieve the output of a remote job. If the job has not finished running when get is called, get blocks until the job finishes running and provides an output.

## Environment Setup

M/s needs the OCaml llvm library, which is most easily installed through opam. Install LLVM and its development libraries, the m4 macro preprocessor, and opam, then use opam to install llvm. The version of the OCaml llvm library should match the version of the LLVM
system installed on your system.

#### Installation under Ubuntu 15.10
LLVM 3.6 is the default under 15.10, so we ask for a matching version of the OCaml library.

```bash
sudo apt-get install -y ocaml m4 llvm opam
opam init
opam install llvm.3.6 ocamlfind
eval `opam config env`
```

To run and test:
In the base directory, make builds the compiler, builds the runtime, and does the necessary linking between the two:

```bash
$ make
ocamlbuild -use-ocamlfind -pkgs llvm,llvm.analysis -cflags -w,+a-4 \
		mscompile.native
Finished, 22 targets (0 cached) in 00:00:02.
/Applications/Xcode.app/Contents/Developer/usr/bin/make -C runtime
gcc -g -Wall   -c -o master.o master.c
gcc -g -Wall   -c -o job_list.o job_list.c
gcc -g -Wall   -c -o slave_queue.o slave_queue.c
gcc -g -Wall   -c -o util.o util.c
ar rc libmsmaster.a master.o job_list.o slave_queue.o util.o
ranlib libmsmaster.a
gcc -g -Wall   -c -o slave.o slave.c
ar rc libmsslave.a slave.o util.o
ranlib libmsslave.a
cp runtime/libms* compiler
```

Testing the compiler:

```bash
$ cd compiler
$ ./testall.sh
test-arith1...OK
test-arith2...OK
test-arith3...OK
test-fib...OK
...
fail-while1...OK
fail-while2...OK
```

You can also run tests individually by running:

```bash
$ ./testall.sh tests/test-arith1.ms
To compile a M/s program file called remote_test.ms:
Inside the compiler directory:
$ ./mscompile.native < remote_test.ms > remote_test.ll
$ llc remote_test.ll
$ gcc -L. remote_test.s -lmsmaster -pthread -lm -o master
$ gcc -L. remote_test.s -lmsslave -pthread -lm -o slave
$ ./master & ./slave
```

## Syntax examples

Please see the Language Reference Manual for a more detailed description. This provides some examples of how to use the features of our language.

### Job syntax
Defining a jobs (as functions that can be sent to slaves):

```
job int f(int a) {
  return 2*a;
}
```

Defining a job object (to refer to a running job):

```
job<int> a = remote f(6);
//job object a contains an int output
```

### Primitives
Our primitives are `int; bool; double; string`.

### Scoping
Master and jobs have their own hierarchy of scope.  There are no globally accessible variables accessible to any combination of the two.  Each if statement, loop, and other block denoted by curly brackets has its own scope.

### Data structures
#### Vector:
* Declaration: `vector<int> a;`
* Nested vectors: `vector<vector<string>> a;`
* Access: `a[0] = 2;`

#### Struct:
* Declaration is done at the same level as master and jobs, and has its own block:
```
struct e {
	int a;
	vector<int> b;
	inner_e x;
};
struct inner_e {
	int c;
};
```

* Instantiation is done anywhere within master or jobs: `struct e s;`
Field access: `s->x->c;`

#### Operators
* Binary operators: `== != < > <= >= && ||`
* Unary operators: `!`

#### Control flow
`If, else, while`
