#!/bin/bash

TEST_FILES=`find ./Tests -type f -not -name "*.out"`


echo "Test $I)"
if [ ! -f matcv.native ]
then
    make
fi

I=0
for FILE in $TEST_FILES
do
    echo "$I) Running test case for $FILE:"

    cat library.matcv $FILE > __run__
    ./matcv.native < __run__ &> __out__
    if [ $? != 0 ]
    then
        echo "Test failed for1: $FILE"
    else
        lli __out__ &>> __output__
        if [ $? != 0 ]
        then
            echo "Test failed for2: $FILE"
        else
            diff __output__ "$FILE".out
            if [ $? != 0 ]
            then
                echo "Test failed for2: $FILE"
            else
                echo "Test passed for: $FILE"
            fi
        fi
    fi

    I=`expr $I + 1`


    rm -f __run__ __out__ __output__

    echo "---------------------------"


done
