/* MatCV Parser */
%{ open Ast %}

/********* TODO ***********/
/**********MATRIX SPLICING? ******/




%token LPAREN  RPAREN  LBRACE RBRACE  LSQBRACKET  RSQBRACKET
%token COLON  SEMI  COMMA  DOT  PLUS  MINUS  TIMES  DIVIDE
%token MATPLUS  MATMINUS  MATTIMES  MATDIVIDE
%token MOD  EXP  ASSIGN  EQ  NEQ  LT  LEQ  GT  GEQ  AND  OR
%token NOT  ROW  COL  ELE PIXEL  VARKEYWORD  CONSTANT
%token IF  ELSE  FOR  BREAK  CONTINUE  EXIT  WHILE  RETURN
%token FUNCTION  TRUE  FALSE  EOF
%token <int> LITERAL
%token <string> ID 

%left SEMI
%left COMMA
%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS MATPLUS MATMINUS
%left TIMES DIVIDE MOD MATTIMES MATDIVIDE
%right NOT NEG
%right EXP
%left DOT
%nonassoc UNBOUNDED



%start program
%type <Ast.program> program


%%

program:
statements EOF {  List.rev (fst $1), snd $1 }

statements:
    /*nothing*/ { [], [] }
    |statements statement { ($2 :: fst $1), snd $1 }
    |statements functionDefinition { fst $1, ($2 :: snd $1) }

statementList:
/*nothing*/ { [] }
| statementList statement { $2 :: $1 }


functionDefinition:
FUNCTION ID LPAREN formalArguments RPAREN LBRACE statementList RBRACE {
    {fname = $2;
	 formals = List.rev $4;
	 body = List.rev $7}}

ifStatement:
IF LPAREN expr RPAREN statement %prec NOELSE { If($3, $5, Block([]))}
| IF LPAREN expr RPAREN statement ELSE statement { If($3, $5, $7) }

blockOfStatements:
LBRACE statementList RBRACE { Block(List.rev $2) }

forLoop:
FOR LPAREN optionalVarAssign SEMI optionalExpression SEMI optionalVarAssign RPAREN statement { For($3, $5, $7, $9) }


optionalVarAssign:
    /*nothing*/ { Nodecl }
| variableDeclaration {$1}

optionalExpression:
/*nothing*/ { Noexpr }
| expr {$1}


whileLoop:
WHILE LPAREN expr RPAREN statement { While($3, $5) }


statement:
    /*nothing*/
| blockOfStatements			{ $1 }
| expr SEMI 				{ Expr $1 }
| variableDeclaration SEMI	{ VarDecl $1 }
| returnStatement  SEMI    	{$1}
| ifStatement				{$1}
| forLoop					{$1}
| whileLoop					{$1}	
| rowLoop					{$1}
| eleLoop					{$1}
| pixelLoop					{$1}
| EXIT SEMI     			{Exit}
| BREAK SEMI        		{Break}
| CONTINUE SEMI	            {Continue}


eleLoop:
    ELE ID COLON ID statement { ForEachLoop ($2, $4, $5, Ele) } 

rowLoop:
    ROW ID COLON ID statement { ForEachLoop ($2, $4, $5, Row) } 

pixelLoop:
    PIXEL ID COLON ID statement { ForEachLoop ($2, $4, $5, Pixel) } 


actualArguments:
/*nothing*/			{[]}
| expr                    { [$1] }
| actualArguments COMMA expr { $3 :: $1 }

formalArguments:
/*nothing*/ { [] }
| ID  { [$1] }
| formalArguments COMMA ID { $3 :: $1 }

returnStatement:
RETURN expr { Return($2) }
| RETURN { Return(Noexpr) }


variableDeclaration:
ID ASSIGN LBRACE matrixInitValues RBRACE { Matrix($1, List.rev (List.rev (fst $4) :: snd $4)) } 
| ID ASSIGN dimensions { DimAssign($1, List.rev $3) } 
| ID ASSIGN expr { ExprAssign($1,$3) } 
| ID dimensions ASSIGN expr { MatElementAssign($1, List.rev $2, $4) }


dimensions:
    LSQBRACKET expr RSQBRACKET { [$2] }
| dimensions LSQBRACKET expr RSQBRACKET {$3 :: $1}


matrixInitValues:
| matrixInitValues COMMA expr {  $3 :: fst $1, snd $1 }
| matrixInitValues SEMI expr  {  [$3],   List.rev (fst $1) :: snd $1}
| expr { [$1], [] }

functionCall:
ID LPAREN actualArguments RPAREN {Call($1, List.rev $3)}

expr:
    LITERAL  { Literal($1) }
  | TRUE	{ BoolLit(true) }
  | FALSE	{ BoolLit(false) }
  | ID      { Id($1) }
  | ID MATPLUS ID     { MatPlus($1, $3) }
  | ID MATMINUS ID     { MatMinus($1, $3) }
  | LT ID COMMA expr GT %prec UNBOUNDED { UnboundedAccessRead($2, $4) } 
  | LSQBRACKET LSQBRACKET ID COMMA expr COMMA expr RSQBRACKET RSQBRACKET %prec UNBOUNDED{ UnboundedAccessWrite($3, $5, $7) } 
  | ID dimensions { MatAccess($1, List.rev $2) }
  | expr PLUS   expr { BinaryOp($1, Add,   $3) }
  | expr MINUS  expr { BinaryOp($1, Sub,   $3) }
  | expr TIMES  expr { BinaryOp($1, Mul,   $3) }
  | expr DIVIDE expr { BinaryOp($1, Div,   $3) }
  | expr MOD    expr { BinaryOp($1, Mod,   $3) }
  | expr EQ     expr { BinaryOp($1, Equal,   $3) }
  | expr NEQ    expr { BinaryOp($1, Neq,   $3) }
  | expr LT     expr { BinaryOp($1, Less,   $3) }
  | expr LEQ    expr { BinaryOp($1, Leq,   $3) }
  | expr GT     expr { BinaryOp($1, Greater,   $3) }
  | expr GEQ    expr { BinaryOp($1, Geq,   $3) }
  | expr AND    expr { BinaryOp($1, And,   $3) }
  | expr OR     expr { BinaryOp($1, Or,   $3) }
  | expr EXP    expr { BinaryOp($1, Exp,   $3) }
  | MINUS expr %prec NEG { Unop(Neg, $2) }
  | NOT expr  { Unop(Not, $2) }
  | functionCall {$1}
  | LPAREN expr RPAREN {$2}
