{ open Parser }

rule token = parse

[' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| ":(" { comment lexbuf } (* Comments *)

| '(' { LPAREN } 
| ')' { RPAREN } 
| '[' { LBRACK }
| ']' { RBRACK }
| '{' { LBRACE }
| '}' { RBRACE }
| '=' { ASSIGN } 

| '+' { PLUS } 
| '-' { MINUS }
| '/' { DIVIDE }
| '*' { TIMES }

| ';' { SEMI }
| ',' { COMMA }
| '&' { AMPER }
| '~' { TILDE }
| '$' { DOLLAR }  
| '@' { AT }

| '!' { NOT }
| '>' { GT }
| '<' { LT }
| ">=" { GEQ }
| "<=" { LEQ }
| "==" { EQ } 
| "!=" { NEQ } 
| "||" { OR }
| "&&" { AND }

| "if" { IF }
| "else" { ELSE }
| "for" { FOR }
| "while" { WHILE }
| "return" { RETURN }
| "null" { NULL }

| "int" { INT }
| "boolean" { BOOL }
| "void" { VOID }
| "true" { TRUE }
| "false" { FALSE }
| "string" { STRING }
| "array" { ARRAY }
| "canvas" { CANVAS }
| "size" { SIZE }
| "rows" { ROWS }
| "columns" { COLUMNS }

| ['0'-'9']+ as lxm { NUM_LIT(int_of_string lxm) }
| '"' (([^ '"'] | "\\\"")* as strlit) '"' { STRING_LIT(strlit) }

| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm { ID(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
":)" { token lexbuf }
| _ { comment lexbuf }
