# crayon
Crayon is a C-style programming language for creating raster graphics, compiled with OCaml into LLVM

## Introduction
Crayon is a raster-graphics creation language that simplifies the digital painting of images through code. Raster graphics are images created from two-dimensional arrays of hex codes that represent the rectangular grid of pixels we see for many computer graphics. Inspired by this paradigm, the Crayon programming language provides a way for the user to create any sort of pixelated image (in color) that they can imagine - like the beautiful creations often made on Microsoft Paint, but worse. 

The crux of Crayon’s design is the assigning of pixel color values to an array-like Canvas. In the same way that a painter assigns different colors to sections of a physical canvas, so can a programmer to Crayon’s digital canvas. The main objective for the programmer should be the artistic or systematic implementation of color. 

## Todo
#### Standard Library
- Color effects (invert, black and white, sepia)
- Lines
- Shapes (circle, square, rectangle, triangle)
- Scaling
- Rotation
- Cutting and pasting images
- ~~Printing arrays, canvas~~
- ~~Adding matrices, arrays~~
- ~~Instantiate canvas with all white (0, 0, 0)~~
- ~~Fill color~~

#### Compiler Stuff
- Exceptions (access out of bound)
- Proofread code
- All tests
- ~~Height and length~~
- ~~Pointers for Canvas~~
- ~~Pointer ref/deref for expressions~~
- ~~Load PPM file from Canvas~~
- Access rows, columns
