(* Ocamllex scanner for LOON 
Authors:
Professor S. Edwards
J. Ricci
N.Christensen
*)

{ open Parser }

rule token = parse
  [' ' '\t' '\r'] { token lexbuf } (* Whitespace *)
  | '('                      {(*ignore(print_endline "Saw LPAREN") ;*) LPAREN }
  | ')'                      {(*ignore(print_endline "Saw RPAREN") ;*) RPAREN }
  | "{|"                     { OPEN_JSON }
  | "|}"                     { CLOSE_JSON }
  | ['\n']*'{'['\n']*        {(*ignore(print_endline "Saw LBRACE") ;*) LBRACE }
  | '}'['\n']*               {(*ignore(print_endline "Saw RBRACE") ;*) RBRACE }
  | '['                      { (*ignore(print_endline "Saw LBRACKET") ;*) LBRACKET }
  | ']'                      {(*ignore(print_endline "Saw LBRACKET") ;*) RBRACKET }
  | ['\n']+                  { (*ignore(print_endline "Saw SEQ") ; *) SEQ }
  | ','                      { COMMA }
  | '+'                      { PLUS }
  | '-'                      { MINUS }
  | '*'                      { TIMES }
  | '/'                      { DIVIDE }
  | '='                      { ASSIGN }
  | ';'                      { SEMI }
  | ':'                      { COLON }
  | "=="                     { EQ }
  | "!="                     { NEQ }
  | '<'                      { LT }
  | "<="                     { LEQ }
  | ">"                      { GT }
  | ">="                     { GEQ }
  | "&&"                     { AND }
  | "||"                     { OR }
  | '|'                      { PIPE }
  | "!"                      { NOT }
  | "if"                     { IF }
  | "else"                   { ELSE }
  | "for"                    { FOR }
  | "while"                  { WHILE }
  | "return"                 { RETURN }
  | "char"                   {(*ignore(print_endline "Saw CHAR") ;*) CHAR }
  | "int"                    {(*ignore(print_endline "Saw INT") ;*) INT }
  | "bool"		             { BOOL }
  | "void"                   {(*ignore(print_endline "Saw VOID") ;*) VOID } 
  | "json"                   { JSON }
  | "pair"                   { PAIR }
  | "string"		         {(*ignore(print_endline "Saw STRING") ;*) STRING }
  | "array"                  { (*ignore(print_endline "Saw ARRAY") ;*) ARRAY }
  | "true"                   { TRUE }
  | "false"                  { FALSE }
  (* StringLit currently allows you to form strings over multiple lines*)
  | '\"' [^'\"']* '\"' as lxm    {(*ignore(print_endline "Saw STRINGLIT") ;*) STRINGLIT(String.sub lxm 1 (String.length lxm - 2)) }
  | ['0'-'9']+ as lxm        { LITERAL(int_of_string lxm) }
  | ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lxm {(* ignore(print_endline "Saw ID") ;*) ID(lxm) }
  | eof { EOF }
  | _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

  and comment = parse
    "*/" { token lexbuf }
    | _    { comment lexbuf }

