/* Ocamlyacc parser for LOON. Written by Niles, Jack, Chelci, and Habin */

%{
open Ast
%}


%token LPAREN RPAREN LBRACE RBRACE
%token LBRACKET RBRACKET
%token OPEN_JSON CLOSE_JSON
%token SEQ COMMA SEMI COLON PIPE
%token PLUS MINUS TIMES DIVIDE ASSIGN
%token EQ NEQ LT LEQ GT GEQ AND OR NOT TRUE FALSE
%token IF ELSE FOR WHILE RETURN

%token INT BOOL STRING VOID PAIR CHAR ARRAY JSON

%token <int> LITERAL
%token <char> CHARLIT
%token <string> STRINGLIT
%token <string> ID
%token EOF

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%right NOT NEG

%start program
%type <Ast.program> program

%%

program:
  decls EOF { $1 }

decls:
   /* nothing */ { [], [] }
 | decls vdecl { ($2 :: fst $1), snd $1 }
 | decls fdecl { fst $1, ($2 :: snd $1) }
/* | decls importDecl { fst $1, ($2 :: snd $1) } */

/* Import Standard library functions. LOOK UP RECURSIVE SCAN CALL*/
/*Need to define Import function, which uses file path and functionID to
return the an func_decl structure representing the desired function. Import(file_path, func_id)
can be located in a separate module, which we open at the top. A future optimization might
build a map of <file_name, list.String func_id> for easy access, rather than perform n fileOpenings
where n is the number of import statements */
/*importDecl:
    FROM STRINGLIT IMPORT ID SEQ { Import($2, $4) }
*/ /* Importing from libraries*/

fdecl:
  typ ID LPAREN formals_opt RPAREN LBRACE stmt_tuple RBRACE
    { { primitive = $1;
    fname = $2;
    formals = $4;
    locals = List.rev (fst $7);
    body = List.rev (snd $7) } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
    typ ID                   { [($1,$2)] }
  | formal_list COMMA typ ID { ($3,$4) :: $1 }

typ:
    INT { Int }
  | BOOL { Bool }
  | VOID { Void }
  | STRING { String}
  | PAIR LT typ GT { Pair $3 }
  | CHAR { Char }
  | ARRAY { Array }
  | JSON { Json }

/*vdecl_list:
    nothing     { [] }
  | vdecl_list vdecl { $2 :: $1 } */

vdecl:
   typ ID SEQ { ($1, $2) }

stmt_tuple:
    /* nothing - Make VDecls list and true statements list */  { ( [], []) }
  | stmt_tuple stmt { (fst $1, $2 :: (snd $1)) }
  | stmt_tuple vdecl { ($2 :: (fst $1), snd $1) }

stmt:
    expr SEQ { Expr $1 }
  | RETURN SEQ { Return Noexpr }
  | RETURN expr SEQ { Return $2 }
  | LBRACE stmt_tuple RBRACE { Block(List.rev (snd $2)) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7) }
  | FOR LPAREN expr_opt SEMI expr SEMI expr_opt RPAREN stmt
     { For($3, $5, $7, $9) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }

expr_opt:
    /* nothing */ { Noexpr }
  | expr          { $1 }

expr:
    LITERAL          { Literal($1) }
  | CHARLIT	     { CharLit($1) }
  | STRINGLIT        { StringLit($1) }
  | TRUE             { BoolLit(true) }
  | FALSE            { BoolLit(false) }
  | ID               { Id($1) }
  | LT expr COMMA expr GT { PairLit($2, $4) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater, $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | expr AND    expr { Binop($1, And,   $3) }
  | expr OR     expr { Binop($1, Or,    $3) }
  | MINUS expr %prec NEG { Unop(Neg, $2) }
  | NOT expr         { Unop(Not, $2) }
  | TIMES expr       { Unop(Deref, $2) }
  | ID access_list_opt ASSIGN expr   { Assign($1, List.rev $2, $4) }
  | ID LPAREN actuals_opt RPAREN { Call($1, $3) }
  | LPAREN expr RPAREN { $2 }
  | ID access_list { Access ($1, List.rev $2) }
  | LBRACKET actuals_opt RBRACKET {ArrayLit($2)}
  | OPEN_JSON pairs_opt CLOSE_JSON   { JsonLit($2) }

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }

pairs_opt:
    /* nothing */ { [] }
  | pairs_list    { List.rev $1 }

pairs_list:
    json_pair                   { [$1] }
  | pairs_list COMMA json_pair  { $3 :: $1 }

json_pair:
    expr COLON expr              { ($1, $3) }

access_list_opt:
    /* nothing */ { [] }
  | access_list   { $1 }

access_list:
    LBRACKET expr RBRACKET { [ $2 ] }
  | access_list LBRACKET expr RBRACKET { $3 :: $1 }
