#!/bin/sh

# Regression testing script for MicroC
# Step through a list of files
#  Compile, run, and check the output of each expected-to-work test
#  Compile and check the error of each expected-to-fail test

# Path to the LLVM compiler
LLC="llc"
#LLC="/usr/local/opt/llvm/bin/llc"

# Path to the C compiler
CC="cc"

# Set time limit for all operations
ulimit -t 30

globallog=testall.log
rm -f $globallog
error=0
globalerror=0

keep=0

Usage() {
    echo "Usage: testall.sh [options] [.mc files]"
    echo "-k    Keep intermediate files"
    echo "-h    Print this help"
    exit 1
}

SignalError() {
    if [ $error -eq 0 ] ; then
	echo "FAILED"
	error=1
    fi
    echo "  $1"
}

Check() {
    error=0
    basename="intermediate"

    generatedfiles=""

    generatedfiles="$generatedfiles ${basename}.ll ${basename}.s" &&
    ./"$1" < "$2" > "${basename}.ll" &&
    $LLC "${basename}.ll" > "${basename}.s" &&
    $CC "${basename}.s" "loon_scanf.o" &&

    # Report the status and clean up the generated files


    if [ $error -eq 0 ] ; then
	if [ $keep -eq 0 ] ; then
	    rm -f $generatedfiles
    fi
    fi
}

while getopts kdpsh c; do
    case $c in
	k) # Keep intermediate files
	    keep=1
	    ;;
	h) # Help
	    Usage
	    ;;
    esac
done

shift `expr $OPTIND - 1`

files=$2

Check $1 $2 2>> $globallog

cat $globallog

exit $globalerror
