/* Ocamlyacc parser for GoBackwards */

%{ open Ast %}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA STRING_TOKEN LBRACKET RBRACKET
%token PLUS MINUS TIMES DIVIDE ASSIGN NOT
%token EQ NEQ LT LEQ GT GEQ TRUE FALSE AND OR
%token RETURN IF ELSE FOR WHILE INT BOOL STRING VOID FUNC VAR

%token <int> LITERAL
%token <string> ID
%token <string> STRINGLIT
%token EOF

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%right NOT NEG


%start program
%type <Ast.program> program

%%

program:
  decls EOF { $1 }

decls:
    /* nothing */ { [], [] }
    | decls vdecl { ($2 :: fst $1), snd $1 }
    | decls fdecl { fst $1, ($2 :: snd $1) }

block:
    LBRACE locals_list stmt_list RBRACE
    { { locals = List.rev $2;
        stmts = List.rev $3 } }

fdecl:
    FUNC ID signature block
  { { fname = $2;
      signature = $3;
      body = $4 } }

signature:
    LPAREN formals_opt RPAREN typ_opt
  { { formals = List.rev $2;
      ret_typ = $4 } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
   ID typ                  { [($2,$1)] }
  | formal_list COMMA ID typ { ($4,$3) :: $1 }

typ_opt:
     { Int }  /* nothing */
  | typ { $1 }

typ:
    INT { Int }
  | BOOL { Bool }
  | STRING { String }
  | array_type {$1}
  | VOID { Void }



array_type:
  | LBRACKET LITERAL RBRACKET typ { ArrayType($4, $2) }


vdecl:
     VAR ID typ SEMI {($3,$2)}

/* NOW WE HAVE TO DO ASSIGNMENTS*/
stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

locals_list:
    /* nothing */  { [] }
  | locals_list vdecl { $2 :: $1 }


stmt:
    expr SEMI { Expr($1) }
  | RETURN SEMI { Return Noexpr }
  | RETURN expr SEMI { Return $2 }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7) }
  | FOR LPAREN expr_opt SEMI expr SEMI expr_opt RPAREN stmt
     { For($3, $5, $7, $9) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }

expr_opt:
    /* nothing */ { Noexpr }
  | expr          { $1 }

expr:
    LITERAL          { Literal($1) }
  | TRUE             { BoolLit(true) }
  | FALSE            { BoolLit(false) }
  | STRINGLIT					{ Strlit( $1 ) }
  | ID               { Id($1) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater, $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | expr AND    expr { Binop($1, And,   $3) }
  | expr OR     expr { Binop($1, Or,    $3) }
  | MINUS expr %prec NEG { Unop(Neg, $2) }
  | NOT expr         { Unop(Not, $2) }
  | expr ASSIGN expr   { Assign ( $1 , $3) }
  | ID LPAREN actuals_opt RPAREN { Call($1, $3) }
  | LPAREN expr RPAREN { $2 }
  | ID LBRACKET expr RBRACKET { AccessArray($1,$3)}

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }
