module tb_vga;
reg 	    clk50, reset;
reg [7:0] array_index;
reg [7:0] array_value;

VGA_LED_Emulator u1( 
	.clk50 (clk50),
	.reset (clk50),
	.array_index (array_index),
	.array_value (array_value)
);

initial begin 
	clk50 = 0;
	array_index[7:0] = 8'd0;
	array_value[7:0] = 8'd0;
	reset = 0;
end

always 
	#5 clk50 = !clk50;

always
begin
	#20 array_index <= array_index + 1; array_value <= 1;
end

endmodule
