/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [7:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [7:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);



	logic[7:0] first_sel,second_sel,third_sel,arrow_sel, score1, score2, array_value, time1, time2, time3,finish;
	logic[7:0] array_address; 
	logic write_en;


      VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	
	always_ff @(posedge clk) begin 
		write_en = 0;
		if(reset)begin
			array_value <= 0;
	
	
		end else if(chipselect && write) begin
		   if (address[7] == 0) begin
				array_value <= writedata[7:0];
				array_address <= address[7:0];
				write_en =1;
			end
			else 
			case(address[4:0])
			5'd0 : first_sel <= writedata;
			5'd1 : second_sel <= writedata;
			5'd2 : third_sel <= writedata;
			5'd3 : score1 <= writedata;
			5'd4 : score2 <= writedata;
			5'd5 : arrow_sel <= writedata;
			5'd6 : time1 <= writedata;
			5'd7 : time2 <= writedata;
			5'd8 : time3 <= writedata;
			5'd10 : finish <= writedata;
			endcase
		end
	end
  
 //assign array_index = 8'd21;
	//assign array_value = 8'd1;
	
endmodule
