# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys
set vga_led 0x0

puts "Started system-console-test-script"

# Using the JTAG chain, check the clock and reset"

set j [lindex [get_service_paths jtag_debug] 0]
open_service jtag_debug $j
puts "Opened jtag_debug"

puts "Checking the JTAG chain loopback: [jtag_debug_loop $j {1 2 3 4 5 6}]"
jtag_debug_reset_system $j

puts -nonewline "Sampling the clock: "
foreach i {1 1 1 1 1 1 1 1 1 1 1 1} {
    puts -nonewline [jtag_debug_sample_clock $j]
}
puts ""

puts "Checking reset state: [jtag_debug_sample_reset $j]"

close_service jtag_debug $j
puts "Closed jtag_debug"

# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

# Write a test pattern to the various registers
# 0 0x320032 2 0x320064 4 0x320096 8 0x3200c8 16 0x3200fa 32 0x32012c 6 0x32015e 7 0x320190 8 0x3201c2 9 0x3201f4
# 4 0x2000064 8 0x2000096 12 0x1ff00c8 16 0x3200fa 20 0x1cc012c 24 0x32015e 28 0x320190 32 0x640190 36 0x2000190 40 0x10004 44 0x3 48 0x0001 52 0x64015e 56 0x0234 60 0x6789
foreach {r v} {288 0x2} {
    master_write_32 $m [expr $vga_led + $r] $v
}

close_service master $m
puts "Closed master"




