#include <pthread.h>
#include "usbkeyboard.h"
#include <stdio.h>
#include <stdlib.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>

pthread_t gamelogic_thread, controller_thread;
pthread_mutex_t lock = PTHREAD_MUTEX_INITIALIZER;
//pthread_cond_t cond = PTHREAD_COND_INITIALIZER;
//int valid = 0;

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;

int vga_led_fd;
unsigned int message[76];
int gridTower[13][20];
int life;
int score;
int coins;
int start;
int play;
int end;
int cursorX;
int cursorY;

/* Write the contents of the array to the display */
void write_segments(const unsigned int segs[76])
{
  vga_led_arg_t vla;
  int i;
	pthread_mutex_lock(&lock);

  for (i = 0 ; i < 76 ; i++) {
    vla.digit = i*4;
    vla.segments = segs[i];
//	printf("%d ", vla.segments);
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }

	pthread_mutex_unlock(&lock);
}

void reset_memory()
{
  vga_led_arg_t vla;
	int i, j;
	unsigned int memory = 0;

    vla.digit = 280;
	for(i = 0; i < 13; i++){
		for(j = 0; j < 20; j++){
			memory = 1048576 + j*512 + i;
    		vla.segments = memory;

    		if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      			perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      			return;
    		}
  		}
	}
}

void gameplay(int iteration){
	
	vga_led_arg_t vla;
	int i, j, m, k;
	time_t t;
	int flyType[10];

	int flyX[10];
	int flyY[10];
	int flyStart[10];
	int flyHealth[10];
	int counter = 0;
	int flagD = 0;
	int bullet[250];
	double traj[100];
	int death = 0;
	int arrive = 0;
	int traj_count = 0;
	message[72] = 1;
	srand((unsigned) time(&t));

	for(i = 0; i < 10; i++){
		if(i == 0) flyY[i] = 12*32;
		else flyY[i] = 0;
		flyHealth[i] = 10 + iteration*4;
		flyX[i] = 0;

		flyType[i] = 2*(rand() % 4) + 1;
	}

	for(i = 0; i < 10; i++)
		if(i == 0)
			flyStart[i] = 1;
		else
			flyStart[i] = 0;

	for(i = 0; i < 250; i++) bullet[i] = 0;
	for(i = 0; i < 100; i++) traj[i] = 0;

	for(;;){
		counter++;

	//Fly moves
		if (counter%500 == 0){
			for(i = 0; i < 10; i++){
				if((flyHealth[i] > 0)&&(!((flyX[i] == 18*32)&&(flyY[i] == 3*32)))){
					if((flyX[i] == 48 )&&(i != 9)){
						flyStart[i+1] = 1;
						flyY[i+1] = 12*32;
					}
				
					if(flyStart[i] == 1){
						if((flyY[i] == 12*32)&&((flyX[i] != 4*32)&&(flyX[i] != 10*32)&&(flyX[i] != 16*32)))
							flyX[i]++;
						else if (((flyY[i] == 3*32))&&((flyX[i] != 7*32)&&(flyX[i] != 13*32)))
							flyX[i]++;
						else if((flyX[i] == 4*32)||(flyX[i] == 10*32)||(flyX[i] == 16*32))
							flyY[i]--;
						else if((flyX[i] == 7*32)||(flyX[i] == 13*32))
							flyY[i]++;
					}
				}	
			}
		}

		for(i = 0; i < 10; i++){
			if((!((flyX[i] == 0)&&(flyY[i] == 0)))&&(flyHealth[i] > 0)
				&&(!((flyX[i] == 18*32)&&(flyY[i] == 3*32)))) {
				if(flyHealth[i] > 5 + iteration) message[59-i] = 1048576*flyType[i] + flyX[i]*1024+flyY[i];
				else message[59-i] = 1048576 + 1048576*flyType[i] + flyX[i]*1024+flyY[i];
			}
			else if ((!((flyX[i] == 0)&&(flyY[i] == 0)))&&(flyHealth[i] <= 0)) {
				flyX[i] = 0;
				flyY[i] = 0;
				message[59-i] = 0;
				death++;
				coins += 10;
				score += 10;
			}
			else if ((flyX[i] == 18*32)&&(flyY[i] == 3*32)){
				flyX[i] = 0;
				flyY[i] = 0;
				message[59-i] = 0;
				life--;
				message[71] = life;
				arrive++;
			}
			//printf("%d\t%d\n", flyX[i], flyY[i]);
		}
		message[74] = (score/1000)*4096+((score%1000)/100)*256+((score%100)/10)*16+score%10;
		message[75] = (coins/1000)*4096+((coins%1000)/100)*256+((coins%100)/10)*16+coins%10;

		if (life == 0) {
			return;
		}
		
	//Tower attack
		if(counter%7500 == 0){		
		for (i = 0; i < 13; i++){
			for (j = 0; j < 20; j++){
				//type 1 tower, attack at most one enemies at a time within 3*3 range
				if(gridTower[i][j] == 1){
					for (m = 0; m < 10; m++){
						if((flyY[m] >= 32*(i))&&(flyY[m] <= 32*(i+2))&&(flyX[m] >= 32*(j-1))&&(flyX[m] <= 32*(j+1))&&(flyHealth[m] > 0)){
							flyHealth[m]--;

							for(k = 0; k < 50; k++){	
								if(bullet[5*k] == 0){
									bullet[5*k] = 1;
									bullet[5*k+1] = j*32 ;
									bullet[5*k+2] = (i+1)*32 ;
									bullet[5*k+3] = flyX[m] ;
									bullet[5*k+4] = flyY[m] ;
									//printf("%d\t%d\t%d\t%d\t%d\n", bullet[5*k], bullet[5*k+1], bullet[5*k+2], bullet[5*k+3], bullet[5*k+4]);
									break;
								}
							}
							break;
						}
					}
				}
				//type 2 tower, attack at most two enemies at a time withtin 3*3 range	
				else if(gridTower[i][j] == 2){
					for (m = 0; m < 10; m++){
						if((flyY[m] >= 32*(i))&&(flyY[m] <= 32*(i+2))&&(flyX[m] >= 32*(j-1))&&(flyX[m] <= 32*(j+1))&&(flyHealth[m] > 0)){
							flyHealth[m]--;
							message[59-m] += 1048576;

							flagD++;
							for(k = 0; k < 50; k++){	
								if(bullet[5*k] == 0){
									bullet[5*k] = 2;
									bullet[5*k+1] = j*32 ;
									bullet[5*k+2] = (i+1)*32 ;
									bullet[5*k+3] = flyX[m] ;
									bullet[5*k+4] = flyY[m] ;
									//printf("%d\t%d\t%d\t%d\t%d\n", bullet[5*k], bullet[5*k+1], bullet[5*k+2], bullet[5*k+3], bullet[5*k+4]);
									break;
								}
							}							
						}
						if(flagD == 2 || m == 9){
							flagD = 0;
							break;							
						}

					}
				}
				//type 3 tower, attack at most one enemies at a time within 4*4 range
				else if(gridTower[i][j] == 3){
					for (m = 0; m < 10; m++){
						if((flyY[m] >= 32*(i))&&(flyY[m] <= 32*(i+2))&&(flyX[m] >= 32*(j-1))&&(flyX[m] <= 32*(j+1))&&(flyHealth[m] > 0)){
							flyHealth[m] -= 2;
							message[59-m] += 1048576;

							for(k = 0; k < 50; k++){	
								if(bullet[5*k] == 0){
									bullet[5*k] = 3;
									bullet[5*k+1] = j*32 ;
									bullet[5*k+2] = (i+1)*32 ;
									bullet[5*k+3] = flyX[m] ;
									bullet[5*k+4] = flyY[m] ;
									//printf("%d\t%d\t%d\t%d\t%d\n", bullet[5*k], bullet[5*k+1], bullet[5*k+2], bullet[5*k+3], bullet[5*k+4]);
									break;
								}
							}
							
							break;
						}
					}
				}							
			}
		}
		}
	
	//Trajectory
		if(counter%100 == 0){
			for(i = 0; i < 50; i++){
				if(bullet[5*i] != 0){
					if((traj[2*i] == 0)&&(traj[2*i+1] == 0)){
						traj[2*i] = bullet[5*i+1];
						traj[2*i+1] = bullet[5*i+2];
					}

				//attacks flies at the bottom-left corner of the tower
					else if ((bullet[5*i+1]>=bullet[5*i+3])&&(bullet[5*i+2]<=bullet[5*i+4])){
						if((traj[2*i] <= bullet[5*i+3])&&(traj[2*i+1] >= bullet[5*i+4])){
							bullet[5*i] = 0;
							traj[2*i] = 0;
							traj[2*i+1] = 0;
							message[i] = 0;
							break;
						}
					
						else{
							traj[2*i] -= (double)(abs(bullet[5*i+1]-bullet[5*i+3]))/30;
							traj[2*i+1] += (double)(abs(bullet[5*i+4]-bullet[5*i+2]))/30;
						}
					}

				//attacks flies at the up-left corner of the tower
					else if ((bullet[5*i+1]>=bullet[5*i+3])&&(bullet[5*i+2]>=bullet[5*i+4])){
						if((traj[2*i] <= bullet[5*i+3])&&(traj[2*i+1] <= bullet[5*i+4])){
							bullet[5*i] = 0;
							traj[2*i] = 0;
							traj[2*i+1] = 0;
							message[i] = 0;
							break;
						}
					
						else{
							traj[2*i] -= (double)(abs(bullet[5*i+1]-bullet[5*i+3]))/30;
							traj[2*i+1] -= (double)(abs(bullet[5*i+4]-bullet[5*i+2]))/30;
						}
					}

				//attacks flies at the bottom-right corner of the tower
					else if ((bullet[5*i+1]<=bullet[5*i+3])&&(bullet[5*i+2]<=bullet[5*i+4])){
						if((traj[2*i] >= bullet[5*i+3])&&(traj[2*i+1] >= bullet[5*i+4])){
							bullet[5*i] = 0;
							traj[2*i] = 0;
							traj[2*i+1] = 0;
							message[i] = 0;
							break;
						}
					
						else{
							traj[2*i] += (double)(abs(bullet[5*i+1]-bullet[5*i+3]))/30;
							traj[2*i+1] += (double)(abs(bullet[5*i+4]-bullet[5*i+2]))/30;
						}
					}

				//attacks flies at the up-right corner of the tower
					else if ((bullet[5*i+1]<=bullet[5*i+3])&&(bullet[5*i+2]>=bullet[5*i+4])){
						if((traj[2*i] >= bullet[5*i+3])&&(traj[2*i+1] <= bullet[5*i+4])){
							bullet[5*i] = 0;
							traj[2*i] = 0;
							traj[2*i+1] = 0;
							message[i] = 0;
							break;
						}
					
						else{
							traj[2*i] += (double)(abs(bullet[5*i+1]-bullet[5*i+3]))/30;
							traj[2*i+1] -= (double)(abs(bullet[5*i+4]-bullet[5*i+2]))/30;
						}
					}
					message[i] = (bullet[5*i]+11)*1048576 + (int)(traj[2*i])*1024 + (int)(traj[2*i+1]);
					//printf("%d\t%d\n", (int)traj[2*i], (int)traj[2*i+1]);
				}else message[i] = 0;
			}
		}

		for(i = 0; i < 100; i++) 
			if(traj[i] != 0) traj_count++;
		if ((death + arrive == 10)&&(traj_count == 0)) return;
		traj_count = 0;
	
	    write_segments(message);

		if(counter == 10001) counter = 1;

		for(;;){
		    vla.digit = 324;
			if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
				perror("ioctl(VGA_LED_READ_DIGIT) failed");
			}
//			printf("%d\n", vla.segments);
			if (vla.segments == 0) break; 
		}
	}
}

void* gamelogic(){
  vga_led_arg_t vla;
  static const char filename[] = "/dev/vga_led";

	int i, j;

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

	do{
		if(start) {
			for(i = 0; i < 13; i++){
				for(j = 0; j < 20; j++){
					gridTower[i][j] = 0;
				}
			}

			reset_memory();
			coins = 200;
			score = 0;
			life = 5;
			cursorX = 0;
			cursorY = 0;
			for(i = 0; i < 76; i++) {
				if(i == 71) message[i] = life;
				else if(i == 75) message[i] = (coins/1000)*4096+((coins%1000)/100)*256+((coins%100)/10)*16+coins%10;
				else if(i == 69) message[i] = 5;
				else message[i] = 0;
			}
			
			for(i = 0; i < 13; i++){
				for(j = 0; j < 20; j++){
					gridTower[i][j] = 0;
				}
			}
			write_segments(message);
		}

		else if(play){
			for(i = 0; i < 13; i++){
				for(j = 0; j < 20; j++){
					gridTower[i][j] = 0;
				}
			}
			write_segments(message);
			coins = 200;
			score = 0;
			life = 5;
			for(i = 0; i < 76; i++) {
				if(i == 71) message[i] = life;
				else if(i == 75) message[i] = (coins/1000)*4096+((coins%1000)/100)*256+((coins%100)/10)*16+coins%10;
				else if(i == 68) message[i] = (((1)%100)/10)*16+(1)%10;
				else if(i == 69) message[i] = 16;
				else if(i == 72) message[i] = 2;
				else message[i] = 0;
			}

			write_segments(message);
			
			usleep(3000000);
			message[69] = 0;
			write_segments(message);

			for(i = 0; ; i++){
				gameplay(i);
				for(j = 0; j < 60; j++) {
					message[j] = 0;
				}
		
				message[69] = 16;
				message[68] = (((i+2)%100)/10)*16+(i+2)%10;
				message[72] = 2;
				write_segments(message);
				if(life == 0){
					end = 1;
					play = 0;
					break;
				}
				
				usleep(3000000);
				message[69] = 0;
				write_segments(message);
			}
		}

		else if(end){
			for(i = 0; i < 13; i++){
				for(j = 0; j < 20; j++){
					gridTower[i][j] = 0;
				}
			}

			for(i = 0; i < 60; i++) {
				message[i] = 0;
			}

			message[69] = 10;
			message[70] = 0;
			write_segments(message);
			reset_memory();
		}

	}while(1);


}

void* controller(){
 	struct usb_keyboard_packet packet;
	int i, j;
	int transferred;
	int tempX, tempY;
	int buildMode = 0;
	int buildType = 0;
	int keyFlag = 0;
	int buildFlag = 0;
	int newTowerX = 0;
	int newTowerY = 0;
	cursorX = 0;
	cursorY = 0;

 	if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
    	fprintf(stderr, "Did not find a keyboard\n");
    	exit(1);
	}

	for(;;){
		libusb_interrupt_transfer(keyboard, endpoint_address, (unsigned char *) &packet, sizeof(packet), &transferred, 0);
		
		if(keyFlag == 1){
			if((packet.keycode[0] == 0x04)&&(cursorX != 0)&&(buildMode == 0)&&(play == 1)){
				cursorX -= 1;
				buildFlag = 0;
			}
			else if((packet.keycode[0] == 0x02)&&(cursorY != 12)&&(buildMode == 0)&&(play == 1)){
				cursorY += 1;
				buildFlag = 0;
			}
			else if((packet.keycode[0] == 0x01)&&(cursorY != 0)&&(buildMode == 0)&&(play == 1)){
				cursorY -= 1;
				buildFlag = 0;
			}
			else if((packet.keycode[0] == 0x08)&&(cursorX != 19)&&(buildMode == 0)&&(play == 1)){
				cursorX += 1;
				buildFlag = 0;
			}
			else if((packet.keycode[1] == 0x10)&&(buildMode == 0)&&(play == 1)){
			if((!(((((cursorX >= 0) && (cursorX <= 4))||((cursorX >= 7) && (cursorX <= 10))||((cursorX >= 13) && (cursorX <= 16)))&&(cursorY == 11))||
				 ((((cursorX >= 4) && (cursorX <= 7))||((cursorX >= 10) && (cursorX <= 13))||((cursorX >= 16) && (cursorX <= 20)))&&(cursorY == 2))||
				 (((cursorX == 4)||(cursorX == 7)||(cursorX == 10)||(cursorX == 13)||(cursorX == 16))&&((cursorY >= 3)&&(cursorY <= 10)))||
				 ((cursorX >= 18)&&(cursorX <= 19)&&(cursorY == 1))))&&
				 (gridTower[cursorY][cursorX] == 0)){
				buildMode = 1;
				buildType = 1;
				tempX = cursorX;
				tempY = cursorY;
				}
			}
			else if((packet.keycode[0] == 0x04)&&(buildType != 1)&&(buildMode == 1)&&(play == 1))
				buildType -= 1; 
			else if((packet.keycode[0] == 0x08)&&(buildType != 3)&&(buildMode == 1)&&(play == 1))
				buildType += 1; 
			else if((packet.keycode[1] == 0x10)&&(buildMode == 1)&&(play == 1)){
				if((buildType == 1)&&(coins >= 50)){
					gridTower[tempY][tempX] = buildType;
					newTowerX = tempX;
					newTowerY = tempY;
					buildMode = 0;
					buildFlag = 1;
					cursorX = tempX;
					cursorY = tempY;
					coins -= 50;
				}else if((buildType == 2)&&(coins >= 100)){
					gridTower[tempY][tempX] = buildType;
					newTowerX = tempX;
					newTowerY = tempY;
					buildMode = 0;
					buildFlag = 1;
					cursorX = tempX;
					cursorY = tempY;
					coins -= 100;
				}else if((buildType == 3)&&(coins >= 150)){
					gridTower[tempY][tempX] = buildType;
					newTowerX = tempX;
					newTowerY = tempY;
					buildMode = 0;
					buildFlag = 1;
					cursorX = tempX;
					cursorY = tempY;
					coins -= 150;
				}
			}
			else if((packet.keycode[1] == 0x20)&&(buildMode == 1)&&(play == 1)){
				buildMode = 0;
				cursorX = tempX;
				cursorY = tempY;
				buildFlag = 0;
			}
			else if ((packet.keycode[0] == 0x10)&&(start == 1)){
				start = 0;
				play = 1;
			}
			else if ((packet.keycode[0] == 0x10)&&(end == 1)){
				start = 0;
				play = 1;
				buildMode = 0;
				buildType = 0;
				keyFlag = 0;
				buildFlag = 0;
				newTowerX = 0;
				newTowerY = 0;
				cursorX = 0;
				cursorY = 0;
			}

			keyFlag = 0;
		}
		else keyFlag = 1;

		if((buildMode == 0)&&(buildFlag ==0)) {
			message[73] = cursorX*65536 + cursorY;
			message[60] = 0;
		}
		else if((buildMode == 0)&&(buildFlag ==1)) {
			message[73] = cursorX*65536 + cursorY;
			message[70] = 1048576 + buildType*262144 + newTowerX*512 + newTowerY;
			message[60] = 0;
		}
		else if(buildMode == 1){
			cursorX = 5 + 2*buildType;	
			cursorY = 13;
			message[73] = cursorX*65536 + cursorY;
			message[60] = (8+buildType)*(1048576) + tempX*1024*32 + (tempY+1)*32;
		}

		message[75] = (coins/1000)*4096+((coins%1000)/100)*256+((coins%100)/10)*16+coins%10;
		write_segments(message);
	}
}

int main()
{
	start = 1;
	play = 0;
	end = 0;

	pthread_create( &gamelogic_thread, NULL, gamelogic, NULL);
	pthread_create( &controller_thread, NULL, controller, NULL);

	pthread_join( gamelogic_thread, NULL);
	pthread_join( controller_thread, NULL);

	return 0;
}
