module rounds_display (
	input  logic clk,
	input  logic [10:0]	 hcount,
    input  logic [9:0] 	 vcount,
	input  logic [31:0]  writedata,
	output logic [7:0]   VGA_R,VGA_G,VGA_B,
	output logic         round_is_valid
 	);

	logic [23:0] zeroQ, oneQ, twoQ, threeQ, fourQ, fiveQ, sixQ, sevenQ, eightQ, nineQ;
	logic [8:0] zeroAddress, oneAddress, twoAddress, threeAddress, fourAddress, fiveAddress, sixAddress, sevenAddress, eightAddress, nineAddress;

	logic [23:0] roundsQ;
	logic [10:0] roundsAddress;

	assign zeroAddress[3:0] = hcount[4:1] + 1;
	assign zeroAddress[8:4] = vcount[4:0];
	assign oneAddress[3:0] = hcount[4:1] + 1;
	assign oneAddress[8:4] = vcount[4:0];
	assign twoAddress[3:0] = hcount[4:1] + 1;
	assign twoAddress[8:4] = vcount[4:0];
	assign threeAddress[3:0] = hcount[4:1] + 1;
	assign threeAddress[8:4] = vcount[4:0];
	assign fourAddress[3:0] = hcount[4:1] + 1;
	assign fourAddress[8:4] = vcount[4:0];
	assign fiveAddress[3:0] = hcount[4:1] + 1;
	assign fiveAddress[8:4] = vcount[4:0];
	assign sixAddress[3:0] = hcount[4:1] + 1;
	assign sixAddress[8:4] = vcount[4:0];
	assign sevenAddress[3:0] = hcount[4:1] + 1;
	assign sevenAddress[8:4] = vcount[4:0];
	assign eightAddress[3:0] = hcount[4:1] + 1;
	assign eightAddress[8:4] = vcount[4:0];
	assign nineAddress[3:0] = hcount[4:1] + 1;
	assign nineAddress[8:4] = vcount[4:0];

	assign roundsAddress[5:0] = hcount[6:1] + 1;
	assign roundsAddress[10:6] = vcount[4:0];

	rounds ROUNDS(.address(roundsAddress), .clock(clk), .q(roundsQ));

	zero ZERO(.address(zeroAddress), .clock(clk), .q(zeroQ));
	one ONE(.address(oneAddress), .clock(clk), .q(oneQ));
	two TWO(.address(twoAddress), .clock(clk), .q(twoQ));
	three THREE(.address(threeAddress), .clock(clk), .q(threeQ));
	four FOUR(.address(fourAddress), .clock(clk), .q(fourQ));
	five FIVE(.address(fiveAddress), .clock(clk), .q(fiveQ));
	six SIX(.address(sixAddress), .clock(clk), .q(sixQ));
	seven SEVEN(.address(sevenAddress), .clock(clk), .q(sevenQ));
	eight EIGHT(.address(eightAddress), .clock(clk), .q(eightQ));
	nine NINE(.address(nineAddress), .clock(clk), .q(nineQ));

	always begin	
		if((hcount[10:7] == 4)&&(vcount[9:5] == 1)) begin
			{VGA_R, VGA_G, VGA_B} = {roundsQ[23:16], roundsQ[15:8], roundsQ[7:0]};
			round_is_valid = 1;
		end else if((hcount[10:5] == 6'd21)&&(vcount[9:5] == 1)) begin
			round_is_valid = 1;
			case(writedata[7:4])
			4'd0: {VGA_R, VGA_G, VGA_B} = {zeroQ[23:16], zeroQ[15:8], zeroQ[7:0]};
			4'd1: {VGA_R, VGA_G, VGA_B} = {oneQ[23:16], oneQ[15:8], oneQ[7:0]};
			4'd2: {VGA_R, VGA_G, VGA_B} = {twoQ[23:16], twoQ[15:8], twoQ[7:0]};
			4'd3: {VGA_R, VGA_G, VGA_B} = {threeQ[23:16], threeQ[15:8], threeQ[7:0]};
			4'd4: {VGA_R, VGA_G, VGA_B} = {fourQ[23:16], fourQ[15:8], fourQ[7:0]};
			4'd5: {VGA_R, VGA_G, VGA_B} = {fiveQ[23:16], fiveQ[15:8], fiveQ[7:0]};
			4'd6: {VGA_R, VGA_G, VGA_B} = {sixQ[23:16], sixQ[15:8], sixQ[7:0]};
			4'd7: {VGA_R, VGA_G, VGA_B} = {sevenQ[23:16], sevenQ[15:8], sevenQ[7:0]};
			4'd8: {VGA_R, VGA_G, VGA_B} = {eightQ[23:16], eightQ[15:8], eightQ[7:0]};
			4'd9: {VGA_R, VGA_G, VGA_B} = {nineQ[23:16], nineQ[15:8], nineQ[7:0]};
			endcase
		end else if((hcount[10:5] == 6'd22)&&(vcount[9:5] == 1)) begin
			round_is_valid = 1;
			case(writedata[3:0])
			4'd0: {VGA_R, VGA_G, VGA_B} = {zeroQ[23:16], zeroQ[15:8], zeroQ[7:0]};
			4'd1: {VGA_R, VGA_G, VGA_B} = {oneQ[23:16], oneQ[15:8], oneQ[7:0]};
			4'd2: {VGA_R, VGA_G, VGA_B} = {twoQ[23:16], twoQ[15:8], twoQ[7:0]};
			4'd3: {VGA_R, VGA_G, VGA_B} = {threeQ[23:16], threeQ[15:8], threeQ[7:0]};
			4'd4: {VGA_R, VGA_G, VGA_B} = {fourQ[23:16], fourQ[15:8], fourQ[7:0]};
			4'd5: {VGA_R, VGA_G, VGA_B} = {fiveQ[23:16], fiveQ[15:8], fiveQ[7:0]};
			4'd6: {VGA_R, VGA_G, VGA_B} = {sixQ[23:16], sixQ[15:8], sixQ[7:0]};
			4'd7: {VGA_R, VGA_G, VGA_B} = {sevenQ[23:16], sevenQ[15:8], sevenQ[7:0]};
			4'd8: {VGA_R, VGA_G, VGA_B} = {eightQ[23:16], eightQ[15:8], eightQ[7:0]};
			4'd9: {VGA_R, VGA_G, VGA_B} = {nineQ[23:16], nineQ[15:8], nineQ[7:0]};
			endcase
		end  else
			round_is_valid = 0;
	end
endmodule
