module cursor_Sprite (
	input logic clk, reset,
	input logic[10:0] hcount,
    input logic[9:0]  vcount,
	input  logic [15:0] fly1_x, fly1_y,
	output logic[7:0] fly1_r, fly1_g, fly1_b,
	output logic fly1_is_valid);
	
// cursor parameter
	logic [9:0] cursorAddress;
	logic [23:0] cursorQ;

	cursor CURSOR(.address(cursorAddress), .clock(clk), .q(cursorQ));
	
always begin
	fly1_is_valid = 1'b0;

	if((hcount[10:6] == fly1_x)&&(vcount[9:5] == fly1_y + 1))	begin
	   		fly1_is_valid = 1'b1;				
			cursorAddress[4:0] = hcount[5:1] + 1;
			cursorAddress[9:5] = vcount[4:0];
			fly1_r = cursorQ[23:16];
			fly1_g = cursorQ[15:8];
			fly1_b = cursorQ[7:0];		
	end
end

endmodule
