module audio_top (
    input               OSC_50_B8A,
	input [3:0]         audio_control,
    inout               AUD_ADCLRCK,AUD_DACLRCK,AUD_BCLK,AUD_I2C_SDAT,
    input               AUD_ADCDAT,
    output              AUD_DACDAT,AUD_XCK, AUD_I2C_SCLK,AUD_MUTE,
    input  [3:0]        KEY,
    input  [3:0]        SW,
    output [3:0]        LED
);

wire reset = !KEY[0];
wire main_clk;
wire audio_clk;
wire [1:0] sample_end;
wire [1:0] sample_req;
wire [15:0] audio_output;
wire [15:0] audio_sample;

wire [15:0] audio_sw;
wire [15:0] audio_ip;
wire [15:0] audio_input;

//background  Background(.clock(OSC_50_B8A), .address(addr_background), .q(background));

test pll (
    .refclk (OSC_50_B8A),
    .rst (reset),
    .outclk_0 (audio_clk),
    .outclk_1 (main_clk)
);

i2c_av_config av_config (
    .clk (main_clk),
    .reset (reset),
    .i2c_sclk (AUD_I2C_SCLK),
    .i2c_sdat (AUD_I2C_SDAT),
    .status (LED)
);

assign AUD_XCK = audio_clk;
assign AUD_MUTE = (SW != 4'b0);

audio_codec Audio_Codec (
    .clk (audio_clk),
    .reset (reset),
    .sample_end (sample_end),
    .sample_req (sample_req),
    .audio_output (audio_output),
    .channel_sel (2'b10),

    .AUD_ADCLRCK (AUD_ADCLRCK),
    .AUD_ADCDAT (AUD_ADCDAT),
    .AUD_DACLRCK (AUD_DACLRCK),
    .AUD_DACDAT (AUD_DACDAT),
    .AUD_BCLK (AUD_BCLK)
);

audio_effects Audio_Effects (
    .clk (audio_clk),
    .sample_end (sample_end[1]),
    .sample_req (sample_req[1]),
    .audio_output (audio_output),
	.control(audio_control)
);



endmodule
