/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
CSEE 4840 Spring 2016 Final project

Group: Crops

Team members: Liang Zhang, Ao Li, Chenli Yuan, and Dingyu Yao

 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
		   /* 32 bit writedata*/
	       input logic [31:0]  writedata,
	       input logic 	  read,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic  [6:0] address,

		   /* 32 bit writedata*/
			output logic[31:0] readdata,
		    output logic[3:0] VGA_audio_control,
			
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n
			 );
   
   
    logic [10:0]			     hcount;
    logic [9:0] 			     vcount;
	logic [3:0]               game_control;


	int tower [259:0];


    logic sprite1_on, sprite2_on, sprite3_on, sprite4_on, sprite5_on, sprite6_on, sprite7_on,
			sprite8_on, sprite9_on, sprite10_on, sprite_on, sprite11_on, sprite12_on, sprite13_on, 
			sprite14_on, sprite15_on, sprite16_on, sprite17_on, sprite18_on, sprite19_on, sprite20_on, 
			sprite21_on, sprite22_on, sprite23_on, sprite24_on, sprite25_on, sprite26_on, sprite27_on, 
			sprite28_on, sprite29_on, sprite30_on, sprite31_on, sprite32_on, sprite33_on, sprite34_on, 
			sprite35_on, sprite36_on, sprite37_on, sprite38_on, sprite39_on, sprite40_on, sprite41_on, 
			sprite42_on, sprite43_on, sprite44_on, sprite45_on, sprite46_on, sprite47_on, sprite48_on, 
			sprite49_on, sprite50_on, sprite51_on, sprite52_on, sprite53_on, sprite54_on, sprite55_on,
         	sprite56_on, sprite57_on, sprite58_on, sprite59_on, sprite60_on, sprite61_on;

    logic [31:0] sprite1, sprite2, sprite3, sprite4, sprite5, sprite6, sprite7, sprite8, sprite9,
				sprite10, sprite11, sprite12, sprite13, sprite14, sprite15, sprite16, sprite17,
                sprite18, sprite19, sprite20, sprite21, sprite22, sprite23, sprite24, sprite25,
                sprite26, sprite27, sprite28, sprite29, sprite30, sprite31, sprite32, sprite33, 
				sprite34, sprite35, sprite36, sprite37, sprite38, sprite39, sprite40, sprite41, 
				sprite42, sprite43, sprite44, sprite45, sprite46, sprite47, sprite48, sprite49, 
				sprite50, sprite51, sprite52, sprite53, sprite54, sprite55, sprite56, sprite57, 
				sprite58, sprite59, sprite60, sprite61;

	logic [19:0] pos_sprite1, pos_sprite2, pos_sprite3, pos_sprite4, pos_sprite5, pos_sprite6, pos_sprite7, pos_sprite8, pos_sprite9, pos_sprite10,
				pos_sprite11, pos_sprite12, pos_sprite13, pos_sprite14, pos_sprite15, pos_sprite16, pos_sprite17, pos_sprite18, pos_sprite19, pos_sprite20,
				pos_sprite21, pos_sprite22, pos_sprite23, pos_sprite24, pos_sprite25, pos_sprite26, pos_sprite27, pos_sprite28, pos_sprite29, pos_sprite30,
				pos_sprite31, pos_sprite32, pos_sprite33, pos_sprite34, pos_sprite35, pos_sprite36, pos_sprite37, pos_sprite38, pos_sprite39, pos_sprite40,
				pos_sprite41, pos_sprite42, pos_sprite43, pos_sprite44, pos_sprite45, pos_sprite46, pos_sprite47, pos_sprite48, pos_sprite49, pos_sprite50,
				pos_sprite51, pos_sprite52, pos_sprite53, pos_sprite54, pos_sprite55, pos_sprite56, pos_sprite57, pos_sprite58, pos_sprite59, pos_sprite60, 				pos_sprite61;

    logic [9:0] addr_sprite1, addr_sprite2, addr_sprite3, addr_sprite4, addr_sprite5, addr_sprite6,
                addr_sprite7, addr_sprite8, addr_sprite9, addr_sprite10, addr_sprite11, addr_sprite12,
                addr_sprite13, addr_sprite14, addr_sprite15, addr_sprite16, addr_sprite17, addr_sprite18,
                addr_sprite19, addr_sprite20, addr_sprite21, addr_sprite22, addr_sprite23, addr_sprite24,
                addr_sprite25, addr_sprite26, addr_sprite27, addr_sprite28, addr_sprite29, addr_sprite30,
				addr_sprite31, addr_sprite32, addr_sprite33, addr_sprite34, addr_sprite35, addr_sprite36,
                addr_sprite37, addr_sprite38, addr_sprite39, addr_sprite40, addr_sprite41, addr_sprite42,
                addr_sprite43, addr_sprite44, addr_sprite45, addr_sprite46, addr_sprite47, addr_sprite48,
                addr_sprite49, addr_sprite50, addr_sprite51, addr_sprite52, addr_sprite53, addr_sprite54,
                addr_sprite55, addr_sprite56, addr_sprite57, addr_sprite58, addr_sprite59, addr_sprite60,
				addr_sprite61, addr_buf;

    logic [11:0] id1, id2, id3, id4, id5, id6, id7, id8, id9, id10, 
				id11, id12, id13, id14, id15, id16, id17, id18, id19, id20,
				id21, id22, id23, id24, id25, id26, id27, id28, id29, id30, 
				id31, id32, id33, id34, id35, id36, id37, id38, id39, id40, 
				id41, id42, id43, id44, id45, id46, id47, id48, id49, id50, 
				id51, id52, id53, id54, id55, id56, id57, id58, id59, id60, 
				id61, id_temp, id_buf;

	logic[23:0] RGB_buf, 
				fly1_RGB, fly2_RGB, moster11_RGB, moster12_RGB, moster21_RGB, moster22_RGB, moster31_RGB, moster32_RGB, 
				blurCorn_RGB, blurCrop_RGB, blurVeggie_RGB, 
				bulletCorn_RGB, bulletCrop_RGB, bulletVeggie_RGB;

	logic[7:0] cursor_r, cursor_g, cursor_b;
   
    logic[19:0]addr_fly1, addr_fly2, addr_moster11, addr_moster12, addr_moster21, addr_moster22, addr_moster31, addr_moster32, 
				addr_blurCorn, addr_blurCrop, addr_blurVeggie,
				addr_bulletCorn, addr_bulletCrop, addr_bulletVeggie; 

// Cursor parameter
    logic[31:0] cursor_pos;
	logic cursor_is_valid;

// Digits parameter
	logic [31:0] digits_score;
	logic [31:0] digits_coins;
	logic [7:0] digits_score_r, digits_score_b, digits_score_g;
	logic [7:0] digits_coins_r, digits_coins_b, digits_coins_g;
	logic digits_score_valid, digits_coins_valid;

// Rounds parameter
	logic [31:0] rounds;
	logic [7:0] rounds_r, rounds_b, rounds_g;
	logic rounds_valid;

// Brand
	logic [31:0] brand;

// Tower parameter
	logic [1:0] towerIn, towerOut;
	logic writeEnable;

// position and hp parameter
	logic [8:0] position_x, position_y;
	logic [8:0] position;
	logic [2:0] hp;

// Tiles parameter
   logic [9:0] grassAddress;
   logic [23:0] grassQ;

   logic [9:0] sandAddress;
   logic [23:0] sandQ;

   logic [11:0] barnAddress;
   logic [23:0] barnQ;

   logic [11:0] trashAddress;
   logic [23:0] trashQ;

   logic [10:0] coinsAddress;
   logic [23:0] coinsQ;

   logic [10:0] lifeAddress;
   logic [23:0] lifeQ;

   logic [10:0] scoreAddress;
   logic [23:0] scoreQ;

   logic [9:0] heartAddress;
   logic [23:0] heartQ;

   logic [9:0] cornAddress;
   logic [23:0] cornQ;

   logic [9:0] cropAddress;
   logic [23:0] cropQ;

   logic [9:0] veggieAddress;
   logic [23:0] veggieQ;

   logic [13:0] tdAddress;
   logic [23:0] tdQ;

   logic [13:0] goAddress;
   logic [23:0] goQ;

   logic [12:0] pbAddress;
   logic [23:0] pbQ;

   logic [12:0] prAddress;
   logic [23:0] prQ;


	logic[8:0] curpos_x, curpos_y;
	logic[8:0] curpos;

    logic sand, barn, trash, coins, life, score, heart, corn, crop, veggie, blackie, cursor, td, go, pb, pr;


/* adudio control */
	assign VGA_audio_control = game_control; 


/* Assign id and sprite position */
    assign id1 = sprite1[31:20];
    assign pos_sprite1 = sprite1[19:0];

    assign id2 = sprite2[31:20];
    assign pos_sprite2 = sprite2[19:0];

    assign id3 = sprite3[31:20];
    assign pos_sprite3 = sprite3[19:0];

    assign id4 = sprite4[31:20];
    assign pos_sprite4 = sprite4[19:0];

    assign id5 = sprite5[31:20];
    assign pos_sprite5 = sprite5[19:0];

    assign id6 = sprite6[31:20];
    assign pos_sprite6 = sprite6[19:0];

    assign id7 = sprite7[31:20];
    assign pos_sprite7 = sprite7[19:0];

    assign id8 = sprite8[31:20];
    assign pos_sprite8 = sprite8[19:0];

    assign id9 = sprite9[31:20];
    assign pos_sprite9 = sprite9[19:0];

    assign id10 = sprite10[31:20];
    assign pos_sprite10 = sprite10[19:0];

    assign id11 = sprite11[31:20];
    assign pos_sprite11 = sprite11[19:0];

    assign id12 = sprite12[31:20];
    assign pos_sprite12 = sprite12[19:0];

    assign id13 = sprite13[31:20];
    assign pos_sprite13 = sprite13[19:0];

    assign id14 = sprite14[31:20];
    assign pos_sprite14 = sprite14[19:0];

    assign id15 = sprite15[31:20];
    assign pos_sprite15 = sprite15[19:0];

    assign id16 = sprite16[31:20];
    assign pos_sprite16 = sprite16[19:0];

    assign id17 = sprite17[31:20];
    assign pos_sprite17 = sprite17[19:0];

    assign id18 = sprite18[31:20];
    assign pos_sprite18 = sprite18[19:0];

    assign id19 = sprite19[31:20];
    assign pos_sprite19 = sprite19[19:0];

    assign id20 = sprite20[31:20];
    assign pos_sprite20 = sprite20[19:0];

    assign id21 = sprite21[31:20];
    assign pos_sprite21 = sprite21[19:0];

    assign id22 = sprite22[31:20];
    assign pos_sprite22 = sprite22[19:0];

    assign id23 = sprite23[31:20];
    assign pos_sprite23 = sprite23[19:0];

    assign id24 = sprite24[31:20];
    assign pos_sprite24 = sprite24[19:0];

    assign id25 = sprite25[31:20];
    assign pos_sprite25 = sprite25[19:0];

    assign id26 = sprite26[31:20];
    assign pos_sprite26 = sprite26[19:0];

    assign id27 = sprite27[31:20];
    assign pos_sprite27 = sprite27[19:0];

    assign id28 = sprite28[31:20];
    assign pos_sprite28 = sprite28[19:0];

    assign id29 = sprite29[31:20];
    assign pos_sprite29 = sprite29[19:0];

    assign id30 = sprite30[31:20];
    assign pos_sprite30 = sprite30[19:0];

    assign id31 = sprite31[31:20];
    assign pos_sprite31 = sprite31[19:0];

    assign id32 = sprite32[31:20];
    assign pos_sprite32 = sprite32[19:0];

    assign id33 = sprite33[31:20];
    assign pos_sprite33 = sprite33[19:0];

    assign id34 = sprite34[31:20];
    assign pos_sprite34 = sprite34[19:0];

    assign id35 = sprite35[31:20];
    assign pos_sprite35 = sprite35[19:0];

    assign id36 = sprite36[31:20];
    assign pos_sprite36 = sprite36[19:0];

    assign id37 = sprite37[31:20];
    assign pos_sprite37 = sprite37[19:0];

    assign id38 = sprite38[31:20];
    assign pos_sprite38 = sprite38[19:0];

    assign id39 = sprite39[31:20];
    assign pos_sprite39 = sprite39[19:0];

    assign id40 = sprite40[31:20];
    assign pos_sprite40 = sprite40[19:0];

    assign id41 = sprite41[31:20];
    assign pos_sprite41 = sprite41[19:0];

    assign id42 = sprite42[31:20];
    assign pos_sprite42 = sprite42[19:0];

    assign id43 = sprite43[31:20];
    assign pos_sprite43 = sprite43[19:0];

    assign id44 = sprite44[31:20];
    assign pos_sprite44 = sprite44[19:0];

    assign id45 = sprite45[31:20];
    assign pos_sprite45 = sprite45[19:0];

    assign id46 = sprite46[31:20];
    assign pos_sprite46 = sprite46[19:0];

    assign id47 = sprite47[31:20];
    assign pos_sprite47 = sprite47[19:0];

    assign id48 = sprite48[31:20];
    assign pos_sprite48 = sprite48[19:0];

    assign id49 = sprite49[31:20];
    assign pos_sprite49 = sprite49[19:0];

    assign id50 = sprite50[31:20];
    assign pos_sprite50 = sprite50[19:0];

    assign id51 = sprite51[31:20];
    assign pos_sprite51 = sprite51[19:0];

    assign id52 = sprite52[31:20];
    assign pos_sprite52 = sprite52[19:0];

    assign id53 = sprite53[31:20];
    assign pos_sprite53 = sprite53[19:0];

    assign id54 = sprite54[31:20];
    assign pos_sprite54 = sprite54[19:0];

    assign id55 = sprite55[31:20];
    assign pos_sprite55 = sprite55[19:0];

    assign id56 = sprite56[31:20];
    assign pos_sprite56 = sprite56[19:0];

    assign id57 = sprite57[31:20];
    assign pos_sprite57 = sprite57[19:0];

    assign id58 = sprite58[31:20];
    assign pos_sprite58 = sprite58[19:0];

    assign id59 = sprite59[31:20];
    assign pos_sprite59 = sprite59[19:0];

    assign id60 = sprite60[31:20];
    assign pos_sprite60 = sprite60[19:0];

    assign id61 = sprite61[31:20];
    assign pos_sprite61 = sprite61[19:0];


/* Assign sprite_on signal all 61 sprites*/

	assign sprite1_on = (sprite1 > 0) ? (((hcount[10:1] >= (pos_sprite1[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite1[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite1[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite1[9:0]+10'd23)))) : 0;
	assign sprite2_on = (sprite2 > 0) ? (((hcount[10:1] >= (pos_sprite2[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite2[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite2[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite2[9:0]+10'd23)))) : 0;
	assign sprite3_on = (sprite3 > 0) ? (((hcount[10:1] >= (pos_sprite3[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite3[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite3[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite3[9:0]+10'd23)))) : 0;
	assign sprite4_on = (sprite4 > 0) ? (((hcount[10:1] >= (pos_sprite4[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite4[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite4[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite4[9:0]+10'd23)))) : 0;
	assign sprite5_on = (sprite5 > 0) ? (((hcount[10:1] >= (pos_sprite5[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite5[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite5[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite5[9:0]+10'd23)))) : 0;
	assign sprite6_on = (sprite6 > 0) ? (((hcount[10:1] >= (pos_sprite6[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite6[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite6[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite6[9:0]+10'd23)))) : 0;
	assign sprite7_on = (sprite7 > 0) ? (((hcount[10:1] >= (pos_sprite7[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite7[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite7[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite7[9:0]+10'd23)))) : 0;
	assign sprite8_on = (sprite8 > 0) ? (((hcount[10:1] >= (pos_sprite8[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite8[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite8[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite8[9:0]+10'd23)))) : 0;
	assign sprite9_on = (sprite9 > 0) ? (((hcount[10:1] >= (pos_sprite9[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite9[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite9[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite9[9:0]+10'd23)))) : 0;
	assign sprite10_on = (sprite10 > 0) ? (((hcount[10:1] >= (pos_sprite10[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite10[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite10[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite10[9:0]+10'd23)))) : 0;

	assign sprite11_on = (sprite11 > 0) ? (((hcount[10:1] >= (pos_sprite11[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite11[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite11[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite11[9:0]+10'd23)))) : 0;
	assign sprite12_on = (sprite12 > 0) ? (((hcount[10:1] >= (pos_sprite12[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite12[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite12[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite12[9:0]+10'd23)))) : 0;
	assign sprite13_on = (sprite13 > 0) ? (((hcount[10:1] >= (pos_sprite13[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite13[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite13[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite13[9:0]+10'd23)))) : 0;
	assign sprite14_on = (sprite14 > 0) ? (((hcount[10:1] >= (pos_sprite14[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite14[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite14[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite14[9:0]+10'd23)))) : 0;
	assign sprite15_on = (sprite15 > 0) ? (((hcount[10:1] >= (pos_sprite15[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite15[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite15[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite15[9:0]+10'd23)))) : 0;
	assign sprite16_on = (sprite16 > 0) ? (((hcount[10:1] >= (pos_sprite16[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite16[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite16[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite16[9:0]+10'd23)))) : 0;
	assign sprite17_on = (sprite17 > 0) ? (((hcount[10:1] >= (pos_sprite17[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite17[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite17[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite17[9:0]+10'd23)))) : 0;
	assign sprite18_on = (sprite18 > 0) ? (((hcount[10:1] >= (pos_sprite18[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite18[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite18[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite18[9:0]+10'd23)))) : 0;
	assign sprite19_on = (sprite19 > 0) ? (((hcount[10:1] >= (pos_sprite19[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite19[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite19[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite19[9:0]+10'd23)))) : 0;
	assign sprite20_on = (sprite20 > 0) ? (((hcount[10:1] >= (pos_sprite20[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite20[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite20[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite20[9:0]+10'd23)))) : 0;

	assign sprite21_on = (sprite21 > 0) ? (((hcount[10:1] >= (pos_sprite21[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite21[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite21[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite21[9:0]+10'd23)))) : 0;
	assign sprite22_on = (sprite22 > 0) ? (((hcount[10:1] >= (pos_sprite22[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite22[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite22[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite22[9:0]+10'd23)))) : 0;
	assign sprite23_on = (sprite23 > 0) ? (((hcount[10:1] >= (pos_sprite23[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite23[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite23[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite23[9:0]+10'd23)))) : 0;
	assign sprite24_on = (sprite24 > 0) ? (((hcount[10:1] >= (pos_sprite24[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite24[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite24[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite24[9:0]+10'd23)))) : 0;
	assign sprite25_on = (sprite25 > 0) ? (((hcount[10:1] >= (pos_sprite25[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite25[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite25[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite25[9:0]+10'd23)))) : 0;
	assign sprite26_on = (sprite26 > 0) ? (((hcount[10:1] >= (pos_sprite26[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite26[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite26[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite26[9:0]+10'd23)))) : 0;
	assign sprite27_on = (sprite27 > 0) ? (((hcount[10:1] >= (pos_sprite27[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite27[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite27[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite27[9:0]+10'd23)))) : 0;
	assign sprite28_on = (sprite28 > 0) ? (((hcount[10:1] >= (pos_sprite28[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite28[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite28[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite28[9:0]+10'd23)))) : 0;
	assign sprite29_on = (sprite29 > 0) ? (((hcount[10:1] >= (pos_sprite29[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite29[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite29[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite29[9:0]+10'd23)))) : 0;
	assign sprite30_on = (sprite30 > 0) ? (((hcount[10:1] >= (pos_sprite30[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite30[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite30[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite30[9:0]+10'd23)))) : 0;

	assign sprite31_on = (sprite31 > 0) ? (((hcount[10:1] >= (pos_sprite31[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite31[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite31[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite31[9:0]+10'd23)))) : 0;
	assign sprite32_on = (sprite32 > 0) ? (((hcount[10:1] >= (pos_sprite32[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite32[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite32[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite32[9:0]+10'd23)))) : 0;
	assign sprite33_on = (sprite33 > 0) ? (((hcount[10:1] >= (pos_sprite33[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite33[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite33[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite33[9:0]+10'd23)))) : 0;
	assign sprite34_on = (sprite34 > 0) ? (((hcount[10:1] >= (pos_sprite34[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite34[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite34[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite34[9:0]+10'd23)))) : 0;
	assign sprite35_on = (sprite35 > 0) ? (((hcount[10:1] >= (pos_sprite35[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite35[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite35[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite35[9:0]+10'd23)))) : 0;
	assign sprite36_on = (sprite36 > 0) ? (((hcount[10:1] >= (pos_sprite36[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite36[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite36[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite36[9:0]+10'd23)))) : 0;
	assign sprite37_on = (sprite37 > 0) ? (((hcount[10:1] >= (pos_sprite37[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite37[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite37[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite37[9:0]+10'd23)))) : 0;
	assign sprite38_on = (sprite38 > 0) ? (((hcount[10:1] >= (pos_sprite38[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite38[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite38[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite38[9:0]+10'd23)))) : 0;
	assign sprite39_on = (sprite39 > 0) ? (((hcount[10:1] >= (pos_sprite39[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite39[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite39[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite39[9:0]+10'd23)))) : 0;
	assign sprite40_on = (sprite40 > 0) ? (((hcount[10:1] >= (pos_sprite40[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite40[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite40[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite40[9:0]+10'd23)))) : 0;

	assign sprite41_on = (sprite41 > 0) ? (((hcount[10:1] >= (pos_sprite41[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite41[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite41[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite41[9:0]+10'd23)))) : 0;
	assign sprite42_on = (sprite42 > 0) ? (((hcount[10:1] >= (pos_sprite42[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite42[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite42[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite42[9:0]+10'd23)))) : 0;
	assign sprite43_on = (sprite43 > 0) ? (((hcount[10:1] >= (pos_sprite43[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite43[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite43[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite43[9:0]+10'd23)))) : 0;
	assign sprite44_on = (sprite44 > 0) ? (((hcount[10:1] >= (pos_sprite44[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite44[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite44[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite44[9:0]+10'd23)))) : 0;
	assign sprite45_on = (sprite45 > 0) ? (((hcount[10:1] >= (pos_sprite45[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite45[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite45[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite45[9:0]+10'd23)))) : 0;
	assign sprite46_on = (sprite46 > 0) ? (((hcount[10:1] >= (pos_sprite46[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite46[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite46[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite46[9:0]+10'd23)))) : 0;
	assign sprite47_on = (sprite47 > 0) ? (((hcount[10:1] >= (pos_sprite47[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite47[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite47[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite47[9:0]+10'd23)))) : 0;
	assign sprite48_on = (sprite48 > 0) ? (((hcount[10:1] >= (pos_sprite48[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite48[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite48[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite48[9:0]+10'd23)))) : 0;
	assign sprite49_on = (sprite49 > 0) ? (((hcount[10:1] >= (pos_sprite49[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite49[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite49[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite49[9:0]+10'd23)))) : 0;
	assign sprite50_on = (sprite50 > 0) ? (((hcount[10:1] >= (pos_sprite50[19:10] + 10'd7))&&(hcount[10:1] <= (pos_sprite50[19:10]+10'd23)))&&((vcount[9:0] >= (pos_sprite50[9:0] + 10'd7))&&(vcount[9:0] <= (pos_sprite50[9:0]+10'd23)))) : 0;



	assign sprite51_on = (sprite51 > 0) ? (((hcount[10:1] >= pos_sprite51[19:10])&&(hcount[10:1] <= (pos_sprite51[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite51[9:0])&&(vcount[9:0] <= (pos_sprite51[9:0]+10'd31)))) : 0;
	assign sprite52_on = (sprite52 > 0) ? (((hcount[10:1] >= pos_sprite52[19:10])&&(hcount[10:1] <= (pos_sprite52[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite52[9:0])&&(vcount[9:0] <= (pos_sprite52[9:0]+10'd31)))) : 0;
	assign sprite53_on = (sprite53 > 0) ? (((hcount[10:1] >= pos_sprite53[19:10])&&(hcount[10:1] <= (pos_sprite53[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite53[9:0])&&(vcount[9:0] <= (pos_sprite53[9:0]+10'd31)))) : 0;
	assign sprite54_on = (sprite54 > 0) ? (((hcount[10:1] >= pos_sprite54[19:10])&&(hcount[10:1] <= (pos_sprite54[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite54[9:0])&&(vcount[9:0] <= (pos_sprite54[9:0]+10'd31)))) : 0;
	assign sprite55_on = (sprite55 > 0) ? (((hcount[10:1] >= pos_sprite55[19:10])&&(hcount[10:1] <= (pos_sprite55[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite55[9:0])&&(vcount[9:0] <= (pos_sprite55[9:0]+10'd31)))) : 0;
	assign sprite56_on = (sprite56 > 0) ? (((hcount[10:1] >= pos_sprite56[19:10])&&(hcount[10:1] <= (pos_sprite56[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite56[9:0])&&(vcount[9:0] <= (pos_sprite56[9:0]+10'd31)))) : 0;
	assign sprite57_on = (sprite57 > 0) ? (((hcount[10:1] >= pos_sprite57[19:10])&&(hcount[10:1] <= (pos_sprite57[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite57[9:0])&&(vcount[9:0] <= (pos_sprite57[9:0]+10'd31)))) : 0;
	assign sprite58_on = (sprite58 > 0) ? (((hcount[10:1] >= pos_sprite58[19:10])&&(hcount[10:1] <= (pos_sprite58[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite58[9:0])&&(vcount[9:0] <= (pos_sprite58[9:0]+10'd31)))) : 0;
	assign sprite59_on = (sprite59 > 0) ? (((hcount[10:1] >= pos_sprite59[19:10])&&(hcount[10:1] <= (pos_sprite59[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite59[9:0])&&(vcount[9:0] <= (pos_sprite59[9:0]+10'd31)))) : 0;
	assign sprite60_on = (sprite60 > 0) ? (((hcount[10:1] >= pos_sprite60[19:10])&&(hcount[10:1] <= (pos_sprite60[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite60[9:0])&&(vcount[9:0] <= (pos_sprite60[9:0]+10'd31)))) : 0;

	assign sprite61_on = (sprite61 > 0) ? (((hcount[10:1] >= pos_sprite61[19:10])&&(hcount[10:1] <= (pos_sprite61[19:10]+10'd31)))&&((vcount[9:0] >= pos_sprite61[9:0])&&(vcount[9:0] <= (pos_sprite61[9:0]+10'd31)))) : 0;


/* Assign the addres for sprites*/

	assign addr_sprite1[4:0] = hcount[5:1] - pos_sprite1[14:10] + 1;
	assign addr_sprite1[9:5] = vcount[4:0] - pos_sprite1[4:0];
	assign addr_sprite2[4:0] = hcount[5:1] - pos_sprite2[14:10] + 1;
	assign addr_sprite2[9:5] = vcount[4:0] - pos_sprite2[4:0];
	assign addr_sprite3[4:0] = hcount[5:1] - pos_sprite3[14:10] + 1;
	assign addr_sprite3[9:5] = vcount[4:0] - pos_sprite3[4:0];
	assign addr_sprite4[4:0] = hcount[5:1] - pos_sprite4[14:10] + 1;
	assign addr_sprite4[9:5] = vcount[4:0] - pos_sprite4[4:0];
	assign addr_sprite5[4:0] = hcount[5:1] - pos_sprite5[14:10] + 1;
	assign addr_sprite5[9:5] = vcount[4:0] - pos_sprite5[4:0];
	assign addr_sprite6[4:0] = hcount[5:1] - pos_sprite6[14:10] + 1;
	assign addr_sprite6[9:5] = vcount[4:0] - pos_sprite6[4:0];
	assign addr_sprite7[4:0] = hcount[5:1] - pos_sprite7[14:10] + 1;
	assign addr_sprite7[9:5] = vcount[4:0] - pos_sprite7[4:0];
	assign addr_sprite8[4:0] = hcount[5:1] - pos_sprite8[14:10] + 1;
	assign addr_sprite8[9:5] = vcount[4:0] - pos_sprite8[4:0];
	assign addr_sprite9[4:0] = hcount[5:1] - pos_sprite9[14:10] + 1;
	assign addr_sprite9[9:5] = vcount[4:0] - pos_sprite9[4:0];
	assign addr_sprite10[4:0] = hcount[5:1] - pos_sprite10[14:10] + 1;
	assign addr_sprite10[9:5] = vcount[4:0] - pos_sprite10[4:0];

	assign addr_sprite11[4:0] = hcount[5:1] - pos_sprite11[14:10] + 1;
	assign addr_sprite11[9:5] = vcount[4:0] - pos_sprite11[4:0];
	assign addr_sprite12[4:0] = hcount[5:1] - pos_sprite12[14:10] + 1;
	assign addr_sprite12[9:5] = vcount[4:0] - pos_sprite12[4:0];
	assign addr_sprite13[4:0] = hcount[5:1] - pos_sprite13[14:10] + 1;
	assign addr_sprite13[9:5] = vcount[4:0] - pos_sprite13[4:0];
	assign addr_sprite14[4:0] = hcount[5:1] - pos_sprite14[14:10] + 1;
	assign addr_sprite14[9:5] = vcount[4:0] - pos_sprite14[4:0];
	assign addr_sprite15[4:0] = hcount[5:1] - pos_sprite15[14:10] + 1;
	assign addr_sprite15[9:5] = vcount[4:0] - pos_sprite15[4:0];
	assign addr_sprite16[4:0] = hcount[5:1] - pos_sprite16[14:10] + 1;
	assign addr_sprite16[9:5] = vcount[4:0] - pos_sprite16[4:0];
	assign addr_sprite17[4:0] = hcount[5:1] - pos_sprite17[14:10] + 1;
	assign addr_sprite17[9:5] = vcount[4:0] - pos_sprite17[4:0];
	assign addr_sprite18[4:0] = hcount[5:1] - pos_sprite18[14:10] + 1;
	assign addr_sprite18[9:5] = vcount[4:0] - pos_sprite18[4:0];
	assign addr_sprite19[4:0] = hcount[5:1] - pos_sprite19[14:10] + 1;
	assign addr_sprite19[9:5] = vcount[4:0] - pos_sprite19[4:0];
	assign addr_sprite20[4:0] = hcount[5:1] - pos_sprite20[14:10] + 1;
	assign addr_sprite20[9:5] = vcount[4:0] - pos_sprite20[4:0];

	assign addr_sprite21[4:0] = hcount[5:1] - pos_sprite21[14:10] + 1;
	assign addr_sprite21[9:5] = vcount[4:0] - pos_sprite21[4:0];
	assign addr_sprite22[4:0] = hcount[5:1] - pos_sprite22[14:10] + 1;
	assign addr_sprite22[9:5] = vcount[4:0] - pos_sprite22[4:0];
	assign addr_sprite23[4:0] = hcount[5:1] - pos_sprite23[14:10] + 1;
	assign addr_sprite23[9:5] = vcount[4:0] - pos_sprite23[4:0];
	assign addr_sprite24[4:0] = hcount[5:1] - pos_sprite24[14:10] + 1;
	assign addr_sprite24[9:5] = vcount[4:0] - pos_sprite24[4:0];
	assign addr_sprite25[4:0] = hcount[5:1] - pos_sprite25[14:10] + 1;
	assign addr_sprite25[9:5] = vcount[4:0] - pos_sprite25[4:0];
	assign addr_sprite26[4:0] = hcount[5:1] - pos_sprite26[14:10] + 1;
	assign addr_sprite26[9:5] = vcount[4:0] - pos_sprite26[4:0];
	assign addr_sprite27[4:0] = hcount[5:1] - pos_sprite27[14:10] + 1;
	assign addr_sprite27[9:5] = vcount[4:0] - pos_sprite27[4:0];
	assign addr_sprite28[4:0] = hcount[5:1] - pos_sprite28[14:10] + 1;
	assign addr_sprite28[9:5] = vcount[4:0] - pos_sprite28[4:0];
	assign addr_sprite29[4:0] = hcount[5:1] - pos_sprite29[14:10] + 1;
	assign addr_sprite29[9:5] = vcount[4:0] - pos_sprite29[4:0];
	assign addr_sprite30[4:0] = hcount[5:1] - pos_sprite30[14:10] + 1;
	assign addr_sprite30[9:5] = vcount[4:0] - pos_sprite30[4:0];

	assign addr_sprite31[4:0] = hcount[5:1] - pos_sprite31[14:10] + 1;
	assign addr_sprite31[9:5] = vcount[4:0] - pos_sprite31[4:0];
	assign addr_sprite32[4:0] = hcount[5:1] - pos_sprite32[14:10] + 1;
	assign addr_sprite32[9:5] = vcount[4:0] - pos_sprite32[4:0];
	assign addr_sprite33[4:0] = hcount[5:1] - pos_sprite33[14:10] + 1;
	assign addr_sprite33[9:5] = vcount[4:0] - pos_sprite33[4:0];
	assign addr_sprite34[4:0] = hcount[5:1] - pos_sprite34[14:10] + 1;
	assign addr_sprite34[9:5] = vcount[4:0] - pos_sprite34[4:0];
	assign addr_sprite35[4:0] = hcount[5:1] - pos_sprite35[14:10] + 1;
	assign addr_sprite35[9:5] = vcount[4:0] - pos_sprite35[4:0];
	assign addr_sprite36[4:0] = hcount[5:1] - pos_sprite36[14:10] + 1;
	assign addr_sprite36[9:5] = vcount[4:0] - pos_sprite36[4:0];
	assign addr_sprite37[4:0] = hcount[5:1] - pos_sprite37[14:10] + 1;
	assign addr_sprite37[9:5] = vcount[4:0] - pos_sprite37[4:0];
	assign addr_sprite38[4:0] = hcount[5:1] - pos_sprite38[14:10] + 1;
	assign addr_sprite38[9:5] = vcount[4:0] - pos_sprite38[4:0];
	assign addr_sprite39[4:0] = hcount[5:1] - pos_sprite39[14:10] + 1;
	assign addr_sprite39[9:5] = vcount[4:0] - pos_sprite39[4:0];
	assign addr_sprite40[4:0] = hcount[5:1] - pos_sprite40[14:10] + 1;
	assign addr_sprite40[9:5] = vcount[4:0] - pos_sprite40[4:0];

	assign addr_sprite41[4:0] = hcount[5:1] - pos_sprite41[14:10] + 1;
	assign addr_sprite41[9:5] = vcount[4:0] - pos_sprite41[4:0];
	assign addr_sprite42[4:0] = hcount[5:1] - pos_sprite42[14:10] + 1;
	assign addr_sprite42[9:5] = vcount[4:0] - pos_sprite42[4:0];
	assign addr_sprite43[4:0] = hcount[5:1] - pos_sprite43[14:10] + 1;
	assign addr_sprite43[9:5] = vcount[4:0] - pos_sprite43[4:0];
	assign addr_sprite44[4:0] = hcount[5:1] - pos_sprite44[14:10] + 1;
	assign addr_sprite44[9:5] = vcount[4:0] - pos_sprite44[4:0];
	assign addr_sprite45[4:0] = hcount[5:1] - pos_sprite45[14:10] + 1;
	assign addr_sprite45[9:5] = vcount[4:0] - pos_sprite45[4:0];
	assign addr_sprite46[4:0] = hcount[5:1] - pos_sprite46[14:10] + 1;
	assign addr_sprite46[9:5] = vcount[4:0] - pos_sprite46[4:0];
	assign addr_sprite47[4:0] = hcount[5:1] - pos_sprite47[14:10] + 1;
	assign addr_sprite47[9:5] = vcount[4:0] - pos_sprite47[4:0];
	assign addr_sprite48[4:0] = hcount[5:1] - pos_sprite48[14:10] + 1;
	assign addr_sprite48[9:5] = vcount[4:0] - pos_sprite48[4:0];
	assign addr_sprite49[4:0] = hcount[5:1] - pos_sprite49[14:10] + 1;
	assign addr_sprite49[9:5] = vcount[4:0] - pos_sprite49[4:0];
	assign addr_sprite50[4:0] = hcount[5:1] - pos_sprite50[14:10] + 1;
	assign addr_sprite50[9:5] = vcount[4:0] - pos_sprite50[4:0];

	assign addr_sprite51[4:0] = hcount[5:1] - pos_sprite51[14:10] + 1;
	assign addr_sprite51[9:5] = vcount[4:0] - pos_sprite51[4:0];
	assign addr_sprite52[4:0] = hcount[5:1] - pos_sprite52[14:10] + 1;
	assign addr_sprite52[9:5] = vcount[4:0] - pos_sprite52[4:0];
	assign addr_sprite53[4:0] = hcount[5:1] - pos_sprite53[14:10] + 1;
	assign addr_sprite53[9:5] = vcount[4:0] - pos_sprite53[4:0];
	assign addr_sprite54[4:0] = hcount[5:1] - pos_sprite54[14:10] + 1;
	assign addr_sprite54[9:5] = vcount[4:0] - pos_sprite54[4:0];
	assign addr_sprite55[4:0] = hcount[5:1] - pos_sprite55[14:10] + 1;
	assign addr_sprite55[9:5] = vcount[4:0] - pos_sprite55[4:0];
	assign addr_sprite56[4:0] = hcount[5:1] - pos_sprite56[14:10] + 1;
	assign addr_sprite56[9:5] = vcount[4:0] - pos_sprite56[4:0];
	assign addr_sprite57[4:0] = hcount[5:1] - pos_sprite57[14:10] + 1;
	assign addr_sprite57[9:5] = vcount[4:0] - pos_sprite57[4:0];
	assign addr_sprite58[4:0] = hcount[5:1] - pos_sprite58[14:10] + 1;
	assign addr_sprite58[9:5] = vcount[4:0] - pos_sprite58[4:0];
	assign addr_sprite59[4:0] = hcount[5:1] - pos_sprite59[14:10] + 1;
	assign addr_sprite59[9:5] = vcount[4:0] - pos_sprite59[4:0];
	assign addr_sprite60[4:0] = hcount[5:1] - pos_sprite60[14:10] + 1;
	assign addr_sprite60[9:5] = vcount[4:0] - pos_sprite60[4:0];

	assign addr_sprite61[4:0] = hcount[5:1] - pos_sprite61[14:10] + 1;
	assign addr_sprite61[9:5] = vcount[4:0] - pos_sprite61[4:0];


/* id buffer assign ids for sprites in order, from 1 to 61*/
   assign id_buf = (sprite1_on) ? id1 : 
                    		(sprite2_on) ? id2 : 
                    		(sprite3_on) ? id3 : 
                    		(sprite4_on) ? id4 : 
                    		(sprite5_on) ? id5 : 
                    		(sprite6_on) ? id6 :
                    		(sprite7_on) ? id7 : 
                    		(sprite8_on) ? id8 : 
                    		(sprite9_on) ? id9 : 
                    		(sprite10_on) ? id10 : 

							(sprite11_on) ? id11 : 
                    		(sprite12_on) ? id12 : 
                    		(sprite13_on) ? id13 : 
                    		(sprite14_on) ? id14 : 
                    		(sprite15_on) ? id15 : 
                    		(sprite16_on) ? id16 :
                    		(sprite17_on) ? id17 : 
                    		(sprite18_on) ? id18 : 
                    		(sprite19_on) ? id19 : 
                    		(sprite20_on) ? id20 : 

							(sprite21_on) ? id21 : 
                    		(sprite22_on) ? id22 : 
                    		(sprite23_on) ? id23 : 
                    		(sprite24_on) ? id24 : 
                    		(sprite25_on) ? id25 : 
                    		(sprite26_on) ? id26 :
                    		(sprite27_on) ? id27 : 
                    		(sprite28_on) ? id28 : 
                    		(sprite29_on) ? id29 : 
                    		(sprite30_on) ? id30 : 

							(sprite31_on) ? id31 : 
                    		(sprite32_on) ? id32 : 
                    		(sprite33_on) ? id33 : 
                    		(sprite34_on) ? id34 : 
                    		(sprite35_on) ? id35 : 
                    		(sprite36_on) ? id36 :
                    		(sprite37_on) ? id37 : 
                    		(sprite38_on) ? id38 : 
                    		(sprite39_on) ? id39 : 
                    		(sprite40_on) ? id40 :

							(sprite41_on) ? id41 : 
                    		(sprite42_on) ? id42 : 
                    		(sprite43_on) ? id43 : 
                    		(sprite44_on) ? id44 : 
                    		(sprite45_on) ? id45 : 
                    		(sprite46_on) ? id46 :
                    		(sprite47_on) ? id47 : 
                    		(sprite48_on) ? id48 : 
                    		(sprite49_on) ? id49 : 
                    		(sprite50_on) ? id50 :

							(sprite51_on) ? id51 : 
                    		(sprite52_on) ? id52 : 
                    		(sprite53_on) ? id53 : 
                    		(sprite54_on) ? id54 : 
                    		(sprite55_on) ? id55 : 
                    		(sprite56_on) ? id56 :
                    		(sprite57_on) ? id57 : 
                    		(sprite58_on) ? id58 : 
                    		(sprite59_on) ? id59 : 
                    		(sprite60_on) ? id60 :

                    		(sprite61_on) ? id61 :0;


/* Assign sprites to unique ids*/
    assign addr_fly1 = (id_buf == 12'd1) ? addr_buf : 0;
    assign addr_fly2 = (id_buf == 12'd2) ? addr_buf : 0;
    assign addr_moster11 = (id_buf == 12'd3) ? addr_buf : 0;
    assign addr_moster12 = (id_buf == 12'd4) ? addr_buf : 0;
    assign addr_moster21 = (id_buf == 12'd5) ? addr_buf : 0;
    assign addr_moster22 = (id_buf == 12'd6) ? addr_buf : 0;
    assign addr_moster31 = (id_buf == 12'd7) ? addr_buf : 0;
    assign addr_moster32 = (id_buf == 12'd8) ? addr_buf : 0;
    assign addr_blurCorn = (id_buf == 12'd9) ? addr_buf : 0;
    assign addr_blurCrop = (id_buf == 12'd10) ? addr_buf : 0;
    assign addr_blurVeggie = (id_buf == 12'd11) ? addr_buf : 0;
    assign addr_bulletCorn = (id_buf == 12'd12) ? addr_buf : 0;
    assign addr_bulletCrop = (id_buf == 12'd13) ? addr_buf : 0;
    assign addr_bulletVeggie = (id_buf == 12'd14) ? addr_buf : 0;


/* Assign address for every sprite modules */
	assign grassAddress[4:0] = hcount[5:1] + 1;
	assign grassAddress[9:5] = vcount[4:0];

	assign sandAddress[4:0] = hcount[5:1] + 1;
	assign sandAddress[9:5] = vcount[4:0];

	assign barnAddress[5:0] = hcount[6:1] + 1;
	assign barnAddress[11:6] = vcount[5:0];

	assign trashAddress[4:0] = hcount[5:1] + 1;
	assign trashAddress[9:5] = vcount[4:0];
	
	assign coinsAddress[5:0] = hcount[6:1] + 1;
	assign coinsAddress[10:6] = vcount[4:0];
	
	assign lifeAddress[5:0] = hcount[6:1] + 1;
	assign lifeAddress[10:6] = vcount[4:0];

	assign scoreAddress[5:0] = hcount[6:1] + 1;
	assign scoreAddress[10:6] = vcount[4:0];

	assign heartAddress[4:0] = hcount[5:1] + 1;
	assign heartAddress[9:5] = vcount[4:0];

    assign cornAddress[4:0] = hcount[5:1] + 1;
	assign cornAddress[9:5] = vcount[4:0];
    
    assign cropAddress[4:0] = hcount[5:1] + 1;
	assign cropAddress[9:5] = vcount[4:0];

    assign veggieAddress[4:0] = hcount[5:1] + 1;
	assign veggieAddress[9:5] = vcount[4:0];

    assign tdAddress[7:0] = hcount[8:1] + 1 - 32*6;
	assign tdAddress[13:8] = vcount[5:0];

    assign goAddress[7:0] = hcount[8:1] + 1 - 32*6;
	assign goAddress[13:8] = vcount[5:0];

    assign pbAddress[7:0] = hcount[8:1] + 1 - 32*6;
	assign pbAddress[12:8] = vcount[4:0];

    assign prAddress[7:0] = hcount[8:1] + 1 - 32*6;
	assign prAddress[12:8] = vcount[4:0];

/* Assign curcur parameter */
	assign curpos_x = hcount[10:6];
	assign curpos_y = vcount[9:5] - 1;
	assign curpos = curpos_x + curpos_y*20;
    assign cursor = cursor_is_valid;

/* Assign position for background, static through out the game*/

   assign sand = ((((hcount[10:6] >= 5'd0) && (hcount[10:6] <= 5'd4))||((hcount[10:6] >= 5'd7) && (hcount[10:6] <= 5'd10))||((hcount[10:6] >= 5'd13) && (hcount[10:6] <= 5'd16)))&&(vcount[9:5] == 5'd12))||
				((((hcount[10:6] >= 5'd4) && (hcount[10:6] <= 5'd7))||((hcount[10:6] >= 5'd10) && (hcount[10:6] <= 5'd13))||((hcount[10:6] >= 5'd16) && (hcount[10:6] <= 5'd20)))&&(vcount[9:5] == 5'd3))||
				(((hcount[10:6] == 5'd4)||(hcount[10:6] == 5'd7)||(hcount[10:6] == 5'd10)||(hcount[10:6] == 5'd13)||(hcount[10:6] == 5'd16))&&((vcount[9:5] >= 5'd4)&&(vcount[9:5] <= 5'd11)));

   assign barn = (hcount[10:7] == 9)&&(vcount[9:6] == 1);
   assign trash = (hcount[10:6] == 0)&&(vcount[9:5] == 12);
   assign coins = (hcount[10:7] == 8)&&(vcount[9:5] == 0);
   assign life = (hcount[10:7] == 3)&&(vcount[9:5] == 0);
   assign score = (hcount[10:7] == 0)&&(vcount[9:5] == 0);
   assign heart = ((hcount[10:6] >= 8) && (hcount[10:6] <= 7 + hp))&&(vcount[9:5] == 0);
   assign corn = ((hcount[10:6] == 7)&&(vcount[9:5] == 14))||(towerOut == 2'd1);
   assign crop = (hcount[10:6] == 9)&&(vcount[9:5] == 14)||(towerOut == 2'd2);
   assign veggie = (hcount[10:6] == 11)&&(vcount[9:5] == 14)||(towerOut == 2'd3);
   assign blackie = (vcount[9:5] == 14);
	assign td = (hcount[10:6] >= 6)&&(hcount[10:6] <= 13)&&(vcount[9:6] == 2)&&(brand[0]);
	assign go = (hcount[10:6] >= 6)&&(hcount[10:6] <= 13)&&(vcount[9:6] == 2)&&(brand[1]);
	assign pb = (hcount[10:6] >= 6)&&(hcount[10:6] <= 13)&&(vcount[9:5] == 13)&&(brand[2]);
	assign pr = (hcount[10:6] >= 6)&&(hcount[10:6] <= 13)&&(vcount[9:5] == 13)&&(brand[3]);

	assign position = position_x + position_y*20;



/* Connect to external modules */
 
	VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	fly_1 FLY1(.address(addr_fly1), .clock(clk), .q(fly1_RGB));
	fly_2 FLY2(.address(addr_fly2), .clock(clk), .q(fly2_RGB));
	Moster1_1 Moster1_1(.address(addr_moster11), .clock(clk), .q(moster11_RGB));
	Moster1_2 Moster1_2(.address(addr_moster12), .clock(clk), .q(moster12_RGB));
	Moster2_1 Moster2_1(.address(addr_moster21), .clock(clk), .q(moster21_RGB));
	Moster2_2 Moster2_2(.address(addr_moster22), .clock(clk), .q(moster22_RGB));
	Moster3_1 Moster3_1(.address(addr_moster31), .clock(clk), .q(moster31_RGB));
	Moster3_2 Moster3_2(.address(addr_moster32), .clock(clk), .q(moster32_RGB));
	corn_blur corn_blur(.address(addr_blurCorn), .clock(clk), .q(blurCorn_RGB));
	crop_blur crop_blur(.address(addr_blurCrop), .clock(clk), .q(blurCrop_RGB));
	veggie_blur veggie_blur(.address(addr_blurVeggie), .clock(clk), .q(blurVeggie_RGB));
	bullet_corn bullet_Corn(.address(addr_bulletCorn), .clock(clk), .q(bulletCorn_RGB));
	bullet_crop bullet_Crop(.address(addr_bulletCrop), .clock(clk), .q(bulletCrop_RGB));
	bullet_Veggie bullet_veggie(.address(addr_bulletVeggie), .clock(clk), .q(bulletVeggie_RGB));
	
	twoPortMemory TwoPortMemory(.clk(clk), .aa(position), .ab(curpos), .da(towerIn), .qb(towerOut), .wa(writeEnable));

//Cursor module 
	cursor_Sprite cursor_sprite(.clk(clk), .hcount(hcount), .vcount(vcount), .fly1_x(cursor_pos[31:16]), .fly1_y(cursor_pos[15:0]), .fly1_r(cursor_r), .fly1_g(cursor_g), .fly1_b(cursor_b), .fly1_is_valid(cursor_is_valid));	

// Digits modules 
	digits_score_display Digits_score_display(.clk(clk), .hcount(hcount), .vcount(vcount), .writedata(digits_score), .VGA_R(digits_score_r), .VGA_G(digits_score_g), .VGA_B(digits_score_b), .digit_is_valid(digits_score_valid));

	digits_coins_display Digits_coins_display(.clk(clk), .hcount(hcount), .vcount(vcount), .writedata(digits_coins), .VGA_R(digits_coins_r), .VGA_G(digits_coins_g), .VGA_B(digits_coins_b), .digit_is_valid(digits_coins_valid));

//Rounds
	rounds_display Rounds_display(.clk(clk), .hcount(hcount), .vcount(vcount), .writedata(rounds), .VGA_R(rounds_r), .VGA_G(rounds_g), .VGA_B(rounds_b), .round_is_valid(rounds_valid));

   grass GRASS(.address(grassAddress), .clock(clk), .q(grassQ));
   sand SAND(.address(sandAddress), .clock(clk), .q(sandQ));
   barn BARN(.address(barnAddress), .clock(clk), .q(barnQ));
   trash TRASH(.address(trashAddress), .clock(clk), .q(trashQ));
   coins COINS(.address(coinsAddress), .clock(clk), .q(coinsQ));
   life LIFE(.address(lifeAddress), .clock(clk), .q(lifeQ));
   score SCORE(.address(scoreAddress), .clock(clk), .q(scoreQ));
   heart HEART(.address(heartAddress), .clock(clk), .q(heartQ));
   corn CORN(.address(cornAddress), .clock(clk), .q(cornQ));
   crop CROP(.address(cropAddress), .clock(clk), .q(cropQ));
   veggie VEGGIE(.address(veggieAddress), .clock(clk), .q(veggieQ));
   FarmTD TD(.address(tdAddress), .clock(clk), .q(tdQ));
   Gameover GO(.address(goAddress), .clock(clk), .q(goQ));
   PressBegin PB(.address(pbAddress), .clock(clk), .q(pbQ));
   PressRetry PR(.address(prAddress), .clock(clk), .q(prQ));

/* Put sprite information for address burfer in order*/

    always@(*) begin
        if (sprite1_on) addr_buf = addr_sprite1;
        else if (sprite2_on) addr_buf = addr_sprite2; 
        else if (sprite3_on) addr_buf = addr_sprite3;
        else if (sprite4_on) addr_buf = addr_sprite4;
        else if (sprite5_on) addr_buf = addr_sprite5;
        else if (sprite6_on) addr_buf = addr_sprite6;
        else if (sprite7_on) addr_buf = addr_sprite7;
        else if (sprite8_on) addr_buf = addr_sprite8;
        else if (sprite9_on) addr_buf = addr_sprite9;
        else if (sprite10_on) addr_buf = addr_sprite10;

        else if (sprite11_on) addr_buf = addr_sprite11;
        else if (sprite12_on) addr_buf = addr_sprite12; 
        else if (sprite13_on) addr_buf = addr_sprite13;
        else if (sprite14_on) addr_buf = addr_sprite14;
        else if (sprite15_on) addr_buf = addr_sprite15;
        else if (sprite16_on) addr_buf = addr_sprite16;
        else if (sprite17_on) addr_buf = addr_sprite17;
        else if (sprite18_on) addr_buf = addr_sprite18;
        else if (sprite19_on) addr_buf = addr_sprite19;
        else if (sprite20_on) addr_buf = addr_sprite20;

        else if (sprite21_on) addr_buf = addr_sprite21;
        else if (sprite22_on) addr_buf = addr_sprite22; 
        else if (sprite23_on) addr_buf = addr_sprite23;
        else if (sprite24_on) addr_buf = addr_sprite24;
        else if (sprite25_on) addr_buf = addr_sprite25;
        else if (sprite26_on) addr_buf = addr_sprite26;
        else if (sprite27_on) addr_buf = addr_sprite27;
        else if (sprite28_on) addr_buf = addr_sprite28;
        else if (sprite29_on) addr_buf = addr_sprite29;
        else if (sprite30_on) addr_buf = addr_sprite30;

		else if (sprite31_on) addr_buf = addr_sprite31;
        else if (sprite32_on) addr_buf = addr_sprite32; 
        else if (sprite33_on) addr_buf = addr_sprite33;
        else if (sprite34_on) addr_buf = addr_sprite34;
        else if (sprite35_on) addr_buf = addr_sprite35;
        else if (sprite36_on) addr_buf = addr_sprite36;
        else if (sprite37_on) addr_buf = addr_sprite37;
        else if (sprite38_on) addr_buf = addr_sprite38;
        else if (sprite39_on) addr_buf = addr_sprite39;
        else if (sprite40_on) addr_buf = addr_sprite40;

		else if (sprite41_on) addr_buf = addr_sprite41;
        else if (sprite42_on) addr_buf = addr_sprite42; 
        else if (sprite43_on) addr_buf = addr_sprite43;
        else if (sprite44_on) addr_buf = addr_sprite44;
        else if (sprite45_on) addr_buf = addr_sprite45;
        else if (sprite46_on) addr_buf = addr_sprite46;
        else if (sprite47_on) addr_buf = addr_sprite47;
        else if (sprite48_on) addr_buf = addr_sprite48;
        else if (sprite49_on) addr_buf = addr_sprite49;
        else if (sprite50_on) addr_buf = addr_sprite50;

		else if (sprite51_on) addr_buf = addr_sprite51;
        else if (sprite52_on) addr_buf = addr_sprite52; 
        else if (sprite53_on) addr_buf = addr_sprite53;
        else if (sprite54_on) addr_buf = addr_sprite54;
        else if (sprite55_on) addr_buf = addr_sprite55;
        else if (sprite56_on) addr_buf = addr_sprite56;
        else if (sprite57_on) addr_buf = addr_sprite57;
        else if (sprite58_on) addr_buf = addr_sprite58;
        else if (sprite59_on) addr_buf = addr_sprite59;
        else if (sprite60_on) addr_buf = addr_sprite60;

        else if (sprite61_on) addr_buf = addr_sprite61;
        else addr_buf = 0;
    end


/* Pass RGB info*/
    always@(*) begin
        if (id_buf == 12'd1) RGB_buf = fly1_RGB;
        else if (id_buf == 12'd2) RGB_buf = fly2_RGB;
        else if (id_buf == 12'd3) RGB_buf = moster11_RGB;
        else if (id_buf == 12'd4) RGB_buf = moster12_RGB;
        else if (id_buf == 12'd5) RGB_buf = moster21_RGB;
        else if (id_buf == 12'd6) RGB_buf = moster22_RGB;
        else if (id_buf == 12'd7) RGB_buf = moster31_RGB;
        else if (id_buf == 12'd8) RGB_buf = moster32_RGB;
        else if (id_buf == 12'd9) RGB_buf = blurCorn_RGB;
        else if (id_buf == 12'd10) RGB_buf = blurCrop_RGB;
        else if (id_buf == 12'd11) RGB_buf = blurVeggie_RGB;
        else if (id_buf == 12'd12) RGB_buf = bulletCorn_RGB;
        else if (id_buf == 12'd13) RGB_buf = bulletCrop_RGB;
        else if (id_buf == 12'd14) RGB_buf = bulletVeggie_RGB;
	end
	
/* Display logic for every sprite_on is valid */
	always@(*) begin
		if((RGB_buf != 24'hffffff)) sprite_on = sprite1_on || sprite2_on || sprite3_on || sprite4_on || sprite5_on || sprite6_on || 
											sprite7_on || sprite8_on || sprite9_on || sprite10_on|| sprite11_on || sprite12_on || 
											sprite13_on || sprite14_on || sprite15_on || sprite16_on || sprite17_on || sprite18_on || 
											sprite19_on || sprite20_on || sprite21_on || sprite22_on || sprite23_on || sprite24_on || 
											sprite25_on || sprite26_on || sprite27_on || sprite28_on || sprite29_on || sprite30_on ||
											sprite31_on || sprite32_on || sprite33_on || sprite34_on || sprite35_on || sprite36_on || 
											sprite37_on || sprite38_on || sprite39_on || sprite40_on || sprite41_on || sprite42_on || 
											sprite43_on || sprite44_on || sprite45_on || sprite46_on || sprite47_on || sprite48_on || 
											sprite49_on || sprite50_on || sprite51_on || sprite52_on || sprite53_on || sprite54_on || 
											sprite55_on || sprite56_on || sprite57_on || sprite58_on || sprite59_on || sprite60_on || sprite61_on;
		else sprite_on = 0;
	end



    always_ff @(posedge clk) begin
    	if (reset) begin

/*	set initial display positon of the fly*/
	    sprite1 <= 32'd0;
	    sprite2 <= 32'd0;
	    sprite3 <= 32'd0;
	    sprite4 <= 32'd0;
	    sprite5 <= 32'd0;
	    sprite6 <= 32'd0;
	    sprite7 <= 32'd0;
	    sprite8 <= 32'd0;
	    sprite9 <= 32'd0;
	    sprite10 <= 32'd0;

	    sprite11 <= 32'd0;
	    sprite12 <= 32'd0;
	    sprite13 <= 32'd0;
	    sprite14 <= 32'd0;
	    sprite15 <= 32'd0;
	    sprite16 <= 32'd0;
	    sprite17 <= 32'd0;
	    sprite18 <= 32'd0;
	    sprite19 <= 32'd0;
	    sprite20 <= 32'd0;

	    sprite21 <= 32'd0;
	    sprite22 <= 32'd0;
	    sprite23 <= 32'd0;
	    sprite24 <= 32'd0;
	    sprite25 <= 32'd0;
	    sprite26 <= 32'd0;
	    sprite27 <= 32'd0;
	    sprite28 <= 32'd0;
	    sprite29 <= 32'd0;
	    sprite30 <= 32'd0;

	    sprite31 <= 32'd0;
	    sprite32 <= 32'd0;
	    sprite33 <= 32'd0;
	    sprite34 <= 32'd0;
	    sprite35 <= 32'd0;
	    sprite36 <= 32'd0;
	    sprite37 <= 32'd0;
	    sprite38 <= 32'd0;
	    sprite39 <= 32'd0;
	    sprite40 <= 32'd0;

	    sprite41 <= 32'd0;
	    sprite42 <= 32'd0;
	    sprite43 <= 32'd0;
	    sprite44 <= 32'd0;
	    sprite45 <= 32'd0;
	    sprite46 <= 32'd0;
	    sprite47 <= 32'd0;
	    sprite48 <= 32'd0;
	    sprite49 <= 32'd0;
	    sprite50 <= 32'd0;

	    sprite51 <= 32'd0;
	    sprite52 <= 32'd0;
	    sprite53 <= 32'd0;
	    sprite54 <= 32'd0;
	    sprite55 <= 32'd0;
	    sprite56 <= 32'd0;
	    sprite57 <= 32'd0;
	    sprite58 <= 32'd0;
	    sprite59 <= 32'd0;
	    sprite60 <= 32'd0;

	    sprite61 <= 32'd0;

		rounds <= 32'b0;
		brand <= 32'b0;
		game_control <= 4'b0;
		cursor_pos <= 32'd0;
		digits_score <= 32'b0;
		digits_coins <= 32'b0;
		hp <= 3'd5;


     end else if (chipselect && write) begin
       case (address)

/*	Get the address for x and y */  
	7'd0: sprite1 <= writedata;
	7'd1: sprite2 <= writedata;
	7'd2: sprite3 <= writedata;
	7'd3: sprite4 <= writedata;
	7'd4: sprite5 <= writedata;
	7'd5: sprite6 <= writedata;
	7'd6: sprite7 <= writedata;
	7'd7: sprite8 <= writedata;
	7'd8: sprite9 <= writedata;
	7'd9: sprite10 <= writedata;

	7'd10: sprite11 <= writedata;
	7'd11: sprite12 <= writedata;
	7'd12: sprite13 <= writedata;
	7'd13: sprite14 <= writedata;
	7'd14: sprite15 <= writedata;
	7'd15: sprite16 <= writedata;
	7'd16: sprite17 <= writedata;
	7'd17: sprite18 <= writedata;
	7'd18: sprite19 <= writedata;
	7'd19: sprite20 <= writedata;

	7'd20: sprite21 <= writedata;
	7'd21: sprite22 <= writedata;
	7'd22: sprite23 <= writedata;
	7'd23: sprite24 <= writedata;
	7'd24: sprite25 <= writedata;
	7'd25: sprite26 <= writedata;
	7'd26: sprite27 <= writedata;
	7'd27: sprite28 <= writedata;
	7'd28: sprite29 <= writedata;
	7'd29: sprite30 <= writedata;

	7'd30: sprite31 <= writedata;
	7'd31: sprite32 <= writedata;
	7'd32: sprite33 <= writedata;
	7'd33: sprite34 <= writedata;
	7'd34: sprite35 <= writedata;
	7'd35: sprite36 <= writedata;
	7'd36: sprite37 <= writedata;
	7'd37: sprite38 <= writedata;
	7'd38: sprite39 <= writedata;
	7'd39: sprite40 <= writedata;

	7'd40: sprite41 <= writedata;
	7'd41: sprite42 <= writedata;
	7'd42: sprite43 <= writedata;
	7'd43: sprite44 <= writedata;
	7'd44: sprite45 <= writedata;
	7'd45: sprite46 <= writedata;
	7'd46: sprite47 <= writedata;
	7'd47: sprite48 <= writedata;
	7'd48: sprite49 <= writedata;
	7'd49: sprite50 <= writedata;

	7'd50: sprite51 <= writedata;
	7'd51: sprite52 <= writedata;
	7'd52: sprite53 <= writedata;
	7'd53: sprite54 <= writedata;
	7'd54: sprite55 <= writedata;
	7'd55: sprite56 <= writedata;
	7'd56: sprite57 <= writedata;
	7'd57: sprite58 <= writedata;
	7'd58: sprite59 <= writedata;
	7'd59: sprite60 <= writedata;

	7'd60: sprite61 <= writedata;
	7'd68: rounds <= writedata;
	7'd69: brand <= writedata;
	7'd70: begin
			writeEnable <= writedata[20];
			towerIn <= writedata[19:18];
			position_x <= writedata[17:9];
			position_y <= writedata[8:0];
			end
	7'd71: hp <= writedata[2:0];
	7'd72: game_control <= writedata[3:0];
    7'd73: cursor_pos <= writedata;
	7'd74: digits_score <= writedata;
	7'd75: digits_coins <= writedata;
		endcase
		end
        else if (read && chipselect) begin
            case(address)
                7'd81: readdata <= { 31'b0, VGA_VS };
            endcase
	
		end
	end


/* Give RGB color information for Tiles */
   always_comb begin
      {VGA_R, VGA_G, VGA_B} = {grassQ[23:16], grassQ[15:8], grassQ[7:0]}; // Grass

	if ( sprite_on )
	  {VGA_R, VGA_G, VGA_B} = RGB_buf;    

	else if ( td &&(tdQ[23:16]||tdQ[15:8]||tdQ[7:0]) )	//FarmTD
	  {VGA_R, VGA_G, VGA_B} = {tdQ[23:16], tdQ[15:8], tdQ[7:0]};

	else if ( go &&(goQ[23:16]||goQ[15:8]||goQ[7:0]) )	//GameOver
	  {VGA_R, VGA_G, VGA_B} = {goQ[23:16], goQ[15:8], goQ[7:0]};

	else if ( pb &&(pbQ[23:16]||pbQ[15:8]||pbQ[7:0]) )	//PressBegin
	  {VGA_R, VGA_G, VGA_B} = {pbQ[23:16], pbQ[15:8], pbQ[7:0]};

	else if ( pr &&(prQ[23:16]||prQ[15:8]||prQ[7:0]) )	//PressRetry
	  {VGA_R, VGA_G, VGA_B} = {prQ[23:16], prQ[15:8], prQ[7:0]};
	
	else if ( cursor && (!((cursor_r==8'd255)&&(cursor_g==8'd255)&&(cursor_b==8'd255))))
	  {VGA_R, VGA_G, VGA_B} = {cursor_r, cursor_g, cursor_b};    // Cursor

	else if ( barn )
	  {VGA_R, VGA_G, VGA_B} = {barnQ[23:16], barnQ[15:8], barnQ[7:0]}; 	//Barn

	else if ( trash )
	  {VGA_R, VGA_G, VGA_B} = {trashQ[23:16], trashQ[15:8], trashQ[7:0]}; 	//Trash

	else if ( sand ) // Is it the path?
	  {VGA_R, VGA_G, VGA_B} = {sandQ[23:16], sandQ[15:8], sandQ[7:0]};  // Sand

	else if ( coins &&(coinsQ[23:16]||coinsQ[15:8]||coinsQ[7:0]) )		
	  {VGA_R, VGA_G, VGA_B} = {coinsQ[23:16], coinsQ[15:8], coinsQ[7:0]}; //Coins

	else if ( life &&(lifeQ[23:16]||lifeQ[15:8]||lifeQ[7:0]) )
	  {VGA_R, VGA_G, VGA_B} = {lifeQ[23:16], lifeQ[15:8], lifeQ[7:0]}; 	//Life

	else if ( score &&(scoreQ[23:16]||scoreQ[15:8]||scoreQ[7:0]) )
	  {VGA_R, VGA_G, VGA_B} = {scoreQ[23:16], scoreQ[15:8], scoreQ[7:0]}; //Score

	else if ( rounds_valid && (!((rounds_r==8'd255)&&(rounds_g==8'd255)&&(rounds_b==8'd255)))&&brand[4])
	  {VGA_R, VGA_G, VGA_B} = {rounds_r, rounds_g, rounds_b};

	else if ( digits_score_valid && (!((digits_score_r==8'd255)&&(digits_score_g==8'd255)&&(digits_score_b==8'd255))))
	  {VGA_R, VGA_G, VGA_B} = {digits_score_r, digits_score_g, digits_score_b}; //Score Digits

	else if ( digits_coins_valid &&(!((digits_coins_r==8'd255)&&(digits_coins_g==8'd255)&&(digits_coins_b==8'd255))) )
	  {VGA_R, VGA_G, VGA_B} = {digits_coins_r, digits_coins_g, digits_coins_b}; //Coins Digits

	else if ( heart &&(heartQ[23:16]||heartQ[15:8]||heartQ[7:0]) )
	  {VGA_R, VGA_G, VGA_B} = {heartQ[23:16], heartQ[15:8], heartQ[7:0]}; //Heart

    else if ( corn && (!((cornQ[23:16]==8'd255)&&(cornQ[15:8]==8'd255)&&(cornQ[7:0]==8'd255))))
	  {VGA_R, VGA_G, VGA_B} = {cornQ[23:16], cornQ[15:8], cornQ[7:0]}; //Corn

    else if ( crop && (!((cropQ[23:16]==8'd255)&&(cropQ[15:8]==8'd255)&&(cropQ[7:0]==8'd255))))
	  {VGA_R, VGA_G, VGA_B} = {cropQ[23:16], cropQ[15:8], cropQ[7:0]}; //Crop

    else if ( veggie && (!((veggieQ[23:16]==8'd255)&&(veggieQ[15:8]==8'd255)&&(veggieQ[7:0]==8'd255))))
	  {VGA_R, VGA_G, VGA_B} = {veggieQ[23:16], veggieQ[15:8], veggieQ[7:0]}; //Veggie

    else if ( blackie)
	  {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0}; //Blackie
   end

endmodule


