/*
 * Simple Verilator testbench for the Bresenham module
 *
 * Stephen A. Edwards
 */

#include <iostream>
#include "Vbresenham.h"
#include "verilated.h"

#include <verilated_vcd_c.h>

vluint64_t main_time = 0;

int main(int argc, const char ** argv, const char ** env) {
  Verilated::commandArgs(argc, argv);

  Vbresenham * dut = new Vbresenham;

  Verilated::traceEverOn(true);
  VerilatedVcdC * tfp = new VerilatedVcdC; 
  dut->trace(tfp, 99);
  tfp->open("bresenham.vcd");

  dut->clk = 0;
  dut->x0 = 0;
  dut->y0 = 0;
  dut->x1 = 10;
  dut->y1 = 30;
  dut->start = 1;
  dut->reset = 1;

  dut->eval();
  tfp->dump(main_time);
  main_time++;

  dut->clk = 1;
  dut->eval();
  dut->reset = 0;
  dut->clk = 0;

  dut->eval();
  tfp->dump(main_time);
  main_time++;

  for (int c = 0 ; c < 100 ; c++) {
    dut->clk = !dut->clk;
    dut->eval();
    tfp->dump(main_time);
    main_time++;
  }

  tfp->close();

  exit(0);
}
