{ 
open Parser 

(* authors: William Hom and Joseph Isaac Baker *)
}

rule token = parse
(* whitespace *)
[' ' '\t' '\r' '\n'] { token lexbuf }
(* comments *)
| '#' { comment lexbuf }
(* arithmetic operators *)
| '+'      { PLUS     }   | '-'      { MINUS   }
| '*'      { TIMES    }   | '/'      { DIVIDE  }
| '%'      { MOD      }   | '\''     { TRAN    }
(* relational operators *)  
| '='      { EQUAL    }  | "!="      { NOTEQUAL}
| '<'      { LESS     }  | "<="      { LEQ     }
| '>'      { GREATER  }  | ">="      { GEQ     }
(* logical operators *)
| '!'      { NOT      }   | '&'      { AND     }
| '|'      { OR       } 
(* Assignment *)
| "<-"     { ASSIGN   }
(* bracketing *)
| '{'      { LCURLY   }   | '}'         { RCURLY  }
| '('      { LPAREN   }   | ')'         { RPAREN  }
| '['      { LBRACK   }   | ']'         { RBRACK  }
(* expression markers *)
| ';'      { SEMI     }   | '.'         { DOT     }
| ','      { COMMA    }   | '"'         { DQUOTE  }
(* data types for variables anf functions *)
| "matrix" { MAT_TYP  }   | "void"      { VOID_TYP }
| "number" { NUM_TYP  }   | "string"    { STR_TYP  }   
(* block expressions *)
| "if"     { IF       }   | "else"      { ELSE    }
| "while"  { WHILE    }   | "return"    { RETURN  }
| "for"    { FOR      }   | "in"        { IN      }
(* overloadable operators *)
| '^'      { POW   }      | ".*"       { DOTTIMES }
| "./"     { DOTDIVIDE }  | "operator" { OPERATOR } 
(* numeric types *)
| ['0'-'9']+ as num { INT(int_of_string num) } 
| ['0'-'9']+'.'['0'-'9']+ as num { FLOAT(float_of_string num) }
(* strings *)
| '"'[^'\n' '"']+'"' as str { STRING(str) }
(* identifiers *)
| ['a'-'z' 'A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']* as lit { ID(lit) }
(* meh *)
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }
(* end-of-file *)
| eof { EOF }
(* comments *)
and comment = parse
"\n" { token lexbuf }
| _ { comment lexbuf } (* eat it all! *)
