(* Semantically checked Abstract Syntax Tree *)
(* author: Joseph Isaac Baker & William Hom *)


open Ast

type checked_func_decl = {
  cdtype      : typ;
  cname       : string;
  cparams     : binding list;
  clocal_vars : binding list;
  cbody       : stmt;
}

type checked_program = {
  global_vars : binding list;
  func_decls  : checked_func_decl list;
}


let string_of_cfdecl cfdecl = 
  string_of_typ cfdecl.cdtype ^ " " ^
  cfdecl.cname ^ "(" ^ String.concat ", " (List.map (fun (t, n) -> string_of_typ t ^ " " ^ n) cfdecl.cparams) ^ ") " ^
  "local vars: " ^ String.concat "" (List.map string_of_vdecl cfdecl.clocal_vars) ^ "\n" ^
  string_of_stmt "" cfdecl.cbody

let string_of_checked_program program = 
  "global vars: " ^ String.concat "" (List.map string_of_vdecl program.global_vars) ^ "\n" ^
  "functions: \n" ^ String.concat "\n" (List.map string_of_cfdecl program.func_decls)
