# General Helper functions
matrix range(number start, number end) {
	number len <- end - start + 1;
	number i <- 0;
	matrix r <- [](1, len);
	while (i < len) {
		r[i + 1] <- start + i;
		i <- i + 1;
	}
	return r;
}


void print(matrix A) {
	matrix shape <- shape(A);
	number rs <- shape[1];
	number cs <- shape[2];

	matrix ris <- range(1,rs);
	matrix cis <- range(1,cs);
	for (number ri in ris) {
		for (number ci in cis) {
			printnl (A[ri, ci]);
			if (ci < cs) {
				printnl (", ");
			}
		}
		print("; ");
	}
}

# Number Operations
number operator ^ (number a, number b) {
	number c <- 1;
	while (b > 0) {
		c <- c * a;
		b <- b - 1;
	}

	return c;
}

# Matrix Operations 

# returns true if the matrix shapes are equal.
number operator = (matrix A, matrix B) {
	matrix shapeA <- shape(A);
	matrix shapeB <- shape(B);

	if ((shapeA[1] = shapeB[1]) & (shapeA[2] = shapeB[2])) {
		return 1;
	} else {
		return 0;
	}
}

matrix operator ' (matrix A) {
	matrix shape <- shape(A);
	number rs <- shape[1];
	number cs <- shape[2];
	matrix ris <- range(1,rs);
	matrix cis <- range(1,cs);

	matrix new <- [](cs, rs);
	for (number ri in ris) {
		for (number ci in cis) {
			new[ci,ri] <- A[ri,ci];
		}
	}

	return new;
}

matrix operator - (matrix A) {
    matrix shape <- shape(A);
    number rs <- shape[1];
    number cs <- shape[2];
    matrix ris <- range(1,rs);
    matrix cis <- range(1,cs);

    matrix new <- [](cs, rs);
    for (number ri in ris) {
        for (number ci in cis) {
            new[ci,ri] <- -A[ri,ci];
        }
    }

    return new;
}

matrix operator + (number a, matrix B) {
	matrix shape <- shape(B);
	matrix new <- [](shape[1], shape[2]);

	number x <- 1;
	for (number i in B) {
		new[x] <- a + i;
		x <- x + 1;
	}

	return new;
}
matrix operator + (matrix B, number a) {
	return a + B;
}

matrix operator + (matrix A, matrix B) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);
	number x <- (A = B);

	if (x = 1) {
		matrix r <- range(1, len(A));

		for (number q in r) {
			new[q] <- A[q] + B[q];
		}
	}

	return new;
}

matrix operator - (number a, matrix B) {
	matrix shape <- shape(B);
	matrix new <- [](shape[1], shape[2]);

	number x <- 1;
	for (number i in B) {
		new[x] <- a - i;
		x <- x + 1;
	}

	return new;
}
matrix operator - (matrix A, number b) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);

	number x <- 1;
	for (number i in A) {
		new[x] <- i - b;
		x <- x + 1;
	}

	return new;
}
matrix operator - (matrix A, matrix B) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);
	number x <- (A = B);

	if (x = 1) {
		matrix r <- range(1, len(A));

		for (number q in r) {
			new[q] <- A[q] - B[q];
		}
	}

	return new;
}

matrix operator .* (matrix A, matrix B) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);
	number x <- (A = B);

	if (x = 1) {
		matrix r <- range(1, len(A));

		for (number q in r) {
			new[q] <- A[q] * B[q];
		}
	}
	return new;
}
matrix operator * (matrix A, number b) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);

	matrix r <- range(1, len(A));

	for (number q in r) {
		new[q] <- A[q] * b;
	}
	return new;
}
matrix operator * (number a, matrix B) {
	return B * a;
}

matrix operator * (matrix A, matrix B) {
	matrix Ashape <- shape(A);
	matrix Bshape <- shape(B);
	matrix new <- [](Ashape[1], Bshape[2]);

	if (Ashape[2] = Bshape[1]) {
		matrix ars <- range(1, Ashape[1]);
		matrix ins <- range(1, Ashape[2]);
		matrix bcs <- range(1, Bshape[2]);
		for (number ari in ars) {
			for (number bci in bcs) {
				number sum <- 0;
				for (number i in ins) {
					sum <- sum + A[ari, i] * B[i, bci];
				}
				new[ari, bci] <- sum;
			}
		}

	}
	return new;
}


matrix operator ./ (matrix A, matrix B) {
	matrix shape <- shape(A);
	matrix new <- [](shape[1], shape[2]);
	number x <- (A = B);

	if (x = 1) {
		matrix r <- range(1, len(A));

		for (number q in r) {
			new[q] <- A[q] / B[q];
		}
	}
	return new;
}
