#include <stdlib.h>
#include <stdio.h>
#include "matrix.h"

/*
 * matrix "test" file.
 * author: William Hom
 */

int main() {
// test a zero-matrix.
    struct matrix *my_matrix = zero_matrix_init(66, 34);
    for (int i = 1; i < 6; i++) {
        for (int j = 1; j < 6; j++) {
            printf("%d %d - %.3f\n", i, j, access_element(&my_matrix, i, j));
        }
    }

    struct matrix *m = shape(my_matrix);
    print_matrix(&m);

    printf("%.3f\n", matrix_len(my_matrix));

// testing out a matrix initialization where an array is already defined.
    double **my_vec = (double **) malloc(sizeof(double *) * 2);
    for (int i = 0; i < 2; i++) {
        my_vec[i] = (double *) malloc(sizeof(double) * 3);
    }

    for (int i = 0; i < 2; i++) {
        for (int j = 0; j < 3; j++) {
            my_vec[i][j] = (i + j) * (j + 1);       
        }
    }

    struct matrix *new_matrix = matrix_init(my_vec, 2, 3);
    for (int i = 1; i < 3; i++) {
        for (int j = 1; j < 4; j++) {
            printf("%d %d - %.3f\n", i, j, access_element(&new_matrix, i, j));
        }
    }

    double replaced = replace_element(&new_matrix, 2, 2, 1242);

    printf("%.3f replaced with %.3f\n",
            replaced, 
            access_element(&new_matrix, 2,2));

    print_matrix(&new_matrix);
    delete_matrix(my_matrix);
    delete_matrix(new_matrix);
}
