/*
 * matrix header file
 */

struct matrix {
    double **vectors;
    int rows;
    int columns;
};

// initialize a matrix (here the matrix itself may already be defined, but
// initialization guarantees we always know the shape).
struct matrix* matrix_init(double **vectors, double rows, double columns);

// in the case in which the matrix itself isn't defined, this function may be
// used to initialize a zero-matrix of size m x n.
struct matrix* zero_matrix_init(double rows, double columns);

// access an element in the matrix and return it.
double access_element(struct matrix **mat, double row, double column);

// replaces the element specified by the row and column of the matrix.
// returns the replaced value.
double replace_element
    (struct matrix **mat, double row, double column, double value);

// returns r x c of matrix
double matrix_len(struct matrix *mat);

// returns shape of the matrix in the form of a 2x1 matrix.
struct matrix *shape(struct matrix *mat);

// prints our matrix
void print_matrix(struct matrix **mat);

// delete the matrix and free up memory.
void delete_matrix(struct matrix* matrix);

