#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "matrix.h"

/*
 * matrix implementation
 * author: William HOm
 */

int count_digits(int n) {
    int count = 0;
    while (n != 0) {
        n /= 10;
        count++;
    }

    return count;
}

int find_largest_digits(struct matrix *matrix) {
    int largest_digits = 1;
    for (int i = 0; i < matrix->rows; i++) {
        for (int j = 0; j < matrix->columns; j++) {
            int digit_count = count_digits(matrix->vectors[i][j]);
            if (digit_count > largest_digits) {
                largest_digits = digit_count;
            }
        }
    }

    return largest_digits;
}

double matrix_len(struct matrix *mat) {
    struct matrix *matrix = mat;

    return ((double) matrix->rows * (double) matrix->columns);
}

struct matrix *shape(struct matrix *mat) {
    struct matrix *s = zero_matrix_init(2, 1);
    struct matrix *matrix = mat;

    replace_element(&s, 1, 1, (double) matrix->rows);
    replace_element(&s, 2, 1, (double) matrix->columns);

    return s;
}

struct matrix *zero_matrix_init(double rows, double columns) {
    int r = (int) rows;
    int c = (int) columns;

    struct matrix *matrix = malloc(sizeof(struct matrix));

    matrix->rows = r;
    matrix->columns = c;
    matrix->vectors = (double **) malloc(sizeof(double *) * r);
    for (int i = 0; i < r; i++) {
        matrix->vectors[i] = (double *) malloc(sizeof(double) * c);
    }

    for (int i = 0; i < r; i++) {
        for (int j = 0; j < c; j++) {
            matrix->vectors[i][j] = 0.0;
        }
    }

    return matrix;
}

struct matrix *matrix_init(double **vectors, double rows, double columns) {
    struct matrix *mat = malloc(sizeof(struct matrix));
    mat->vectors = vectors;
    mat->rows = (int) rows;
    mat->columns = (int) columns;

    return mat;
}

double access_element(struct matrix **mat, double row, double column) {
    int r = (int) row;
    int c = (int) column;
    struct matrix *matrix = *mat;

    if (c == 0) {
        int coord = r;
        r = (coord - 1) / matrix->columns;
        c = (coord - 1) % matrix-> columns;
    } else {
        --r; --c;
    }

    double x = matrix->vectors[r][c];

    return x;
}

double replace_element(struct matrix **mat, double row, double column, double value) {
    int r = (int) row;
    int c = (int) column;
    struct matrix *matrix = *mat;

    if (c == 0) {
        int coord = r;
        r = (coord - 1) / matrix->columns;
        c = (coord - 1) % matrix->columns;
    } else {
        --r; --c;
    }

    double x = matrix->vectors[r][c];
    matrix->vectors[r][c] = value;

    return x;
}

void delete_matrix(struct matrix *matrix) {
    for (int i = 0; i < matrix->rows; i++) {
        free(matrix->vectors[i]);
    }

    free(matrix->vectors);
    free(matrix);
}

void print_matrix(struct matrix **mat) {
    struct matrix *matrix = *mat;

    int width = find_largest_digits(matrix);
    
    for (int i = 0; i < matrix->rows; i++) {
        for (int j = 0; j < matrix->columns; j++) {
           printf("%*f ", width, matrix->vectors[i][j]);
        }
        printf("\n");
    }
}
