Macaw v0.1a

Language Summary:
=================
Macaw is a Matlab- and R-inspired language that provides a matrix data type
and by allowing a simple operator overloading mechanism is able to provide a
standard library of matrix manipulation functions. It is a strongly typed,
imperative language that supports simple flow control, looping, and user
defined function constructs. User-defined functions can be aliased to
operators to allow vector and matrix computation to resemble the equations
that users are familiar with.

Installation and Usage:
=======================
Please refer to readme_llvm.md for instructions on how to install all 
dependencies related to the Macaw compiler, courtesy of Professor Stephen A.
Edwards of Columbia University.

In order to compile a Macaw source file, the following command can be issued
from the command prompt from the src directory:

$ make
$ ./mcaw <option> <source file>

Valid input for <option> are as follows:
(not specifying an option defaults to -c)

-a: Prints the AST as well as the SAST of your program. This is primarily
used for debugging purposes.
-c: Compiles your source file to LLVM IR.
-l: Same as -c, but this will ignore errors compiling to LLVM IR. This is used
primarily for debugging and troubleshooting purposes. 

This will generate LLVM IR code to stdout. In order to save it to a file, you
will need to direct your output thusly:

$ ./mcaw <option> <source file> > <destination file>

In order to execute the compiled source, you can execute the lli command (after
running the LLVM installation instructions noted above):

$ lli <compiled source file>

Alternatively, you may compile a source file with the below command using the
same available options. Note that the standard library functions for matrix
manipulation will not be included and your compilation may fail as a result.

$ ./macaw.native <option> < <source file> > <destination file>

The following command will execute the regression test suite (after running 
make):

$ ./testall.sh