# v is a vector of size 2 [x, y]
# approximate_sin returns an approximation of sin(x) + sin(y) at 
# (0.5,0.5) + v using Taylor's Theorem
number approximate_sin(matrix v) {
	matrix H <- [-0.4794, 0; 0, -0.4794];
	matrix g <- [0.8776, 0.8776];
	number f <- 0.9589;

  matrix approx <- f + (g * v') + 0.5 * ((H * v')' * v');
  # approx is a 1x1 matrix
  return approx[1];
}

number a <- approximate_sin([0.02, 0.05]);
print(a);
# a = 1.01964

number b <- approximate_sin([0.1, 0.09]);
print(b);
# b = 1.1213
